package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Favicon 
 */
public abstract class BaseFavicon extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the site field */
    private String site;
          /** the value for the location field */
    private String location;
          /** the value for the status field */
    private int status;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) 
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the Site
     * @return String
     */
     public String getSite()
     {
          return site;
     }

                            
    /**
     * Set the value of Site
     */
     public void setSite(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.site, v) )
        {
                       this.site = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Location
     * @return String
     */
     public String getLocation()
     {
          return location;
     }

                            
    /**
     * Set the value of Location
     */
     public void setLocation(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.location, v) )
        {
                       this.location = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Status
     * @return int
     */
     public int getStatus()
     {
          return status;
     }

                            
    /**
     * Set the value of Status
     */
     public void setStatus(int v ) 
     {
  
  

         if (this.status != v)
        {
                       this.status = v;
                      setModified(true);
        }
     }

  

 
    
        
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Site");
            fieldNames_.add("Location");
            fieldNames_.add("Status");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("Site"))
	{
	  	    return getSite();
	  	}
            if (name.equals("Location"))
	{
	  	    return getLocation();
	  	}
            if (name.equals("Status"))
	{
	  	    return new Integer(getStatus());
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(FaviconPeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(FaviconPeer.SITE ))
	    {
	  	    return getSite();
	  	}
            if (name.equals(FaviconPeer.LOCATION ))
	    {
	  	    return getLocation();
	  	}
            if (name.equals(FaviconPeer.STATUS ))
	    {
	  	    return new Integer(getStatus());
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getSite();
	  	}
            if ( pos == 2 )
	{
	  	    return getLocation();
	  	}
            if ( pos == 3 )
	{
	  	    return new Integer(getStatus());
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(FaviconPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                FaviconPeer.doInsert((Favicon)this, dbCon);
            }
            else
            {
                FaviconPeer.doUpdate((Favicon)this, dbCon);
                setNew(false);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /** 
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id) 
         {
         setId((NumberKey)id);
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
        setId(new NumberKey(key) );
    }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
        return getId();
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Favicon copy() throws Exception
    {
        Favicon copyObj = new Favicon();
        copyObj.setId(id);
        copyObj.setSite(site);
        copyObj.setLocation(location);
        copyObj.setStatus(status);


    
            copyObj.setId((NumberKey)null);
                        return copyObj;
    }
}

