package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;
import java.math.*;
import java.sql.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;
import org.apache.turbine.services.db.TurbineDB;

// Local classes
import org.openprivacy.reptile.om.map.*;

/**
  * This class was autogenerated by Torque on:
  *
  * [Mon Jul 01 17:54:11 PDT 2002]
  *
  */
public abstract class BaseChannelPeer 
    extends BasePeer
{

    /** the mapbuilder for this class */
    private static final ChannelMapBuilder mapBuilder = 
        (ChannelMapBuilder)getMapBuilder(ChannelMapBuilder.CLASS_NAME);

    /** the table name for this class */
    public static final String TABLE_NAME = mapBuilder.getTable();

    /** 
     * @returns the map builder for this peer 
     */
    public static MapBuilder getMapBuilder()
    {
       return(mapBuilder);
    }

    /** the column name for the ID field */
    public static final String ID = mapBuilder.getChannel_Id();
    /** the column name for the LOCATION field */
    public static final String LOCATION = mapBuilder.getChannel_Location();
    /** the column name for the SITE field */
    public static final String SITE = mapBuilder.getChannel_Site();
    /** the column name for the CONTENT_TYPE field */
    public static final String CONTENT_TYPE = mapBuilder.getChannel_ContentType();
    /** the column name for the TITLE field */
    public static final String TITLE = mapBuilder.getChannel_Title();
    /** the column name for the DESCRIPTION field */
    public static final String DESCRIPTION = mapBuilder.getChannel_Description();
    /** the column name for the IMAGE_FK field */
    public static final String IMAGE_FK = mapBuilder.getChannel_ImageFk();
    /** the column name for the SOURCE field */
    public static final String SOURCE = mapBuilder.getChannel_Source();
    /** the column name for the DATE_FOUND field */
    public static final String DATE_FOUND = mapBuilder.getChannel_DateFound();
    /** the column name for the LAST_UPDATED field */
    public static final String LAST_UPDATED = mapBuilder.getChannel_LastUpdated();
    /** the column name for the COPYRIGHT field */
    public static final String COPYRIGHT = mapBuilder.getChannel_Copyright();
    /** the column name for the CATEGORY_FK field */
    public static final String CATEGORY_FK = mapBuilder.getChannel_CategoryFk();
    /** the column name for the SUBSCRIBED field */
    public static final String SUBSCRIBED = mapBuilder.getChannel_Subscribed();
    /** the column name for the INDEXED field */
    public static final String INDEXED = mapBuilder.getChannel_Indexed();
    /** the column name for the INITIALIZED field */
    public static final String INITIALIZED = mapBuilder.getChannel_Initialized();
    /** the column name for the PUBLISHER field */
    public static final String PUBLISHER = mapBuilder.getChannel_Publisher();
    /** the column name for the CREATOR field */
    public static final String CREATOR = mapBuilder.getChannel_Creator();

 
    /** number of columns for this peer */
    public static final int numColumns =  17;

    /** A class that can be returned by this peer. */
    protected static final String CLASSNAME_DEFAULT = 
        "org.openprivacy.reptile.om.Channel";

    /** A class that can be returned by this peer. */
    protected static final Class CLASS_DEFAULT = initClass();

    /** Initialization method for static CLASS_DEFAULT attribute */
    private static Class initClass()
    {
        Class c = null;
        try
        { 
            c = Class.forName(CLASSNAME_DEFAULT);
        }
        catch (Exception e)
        {
            Log.error("A FATAL ERROR has occurred which should not" +
                "have happened under any circumstance.  Please notify" +
                "Turbine and give as many details as possible including the " +
                "error stacktrace.", e);
        }
        return c;
    }


    /**
     * Get the list of objects for a ResultSet.  Please not that your
     * resultset MUST return columns in the right order.  You can use
     * getFieldNames() in BaseObject to get the correct sequence.
     */
    public static Vector resultSet2Objects (java.sql.ResultSet results) throws Exception
    {
        QueryDataSet qds = null;
        Vector rows = null;
        try
        {
            qds = new QueryDataSet( results );
            rows = getSelectResults( qds );
        }
        finally
        {
            if (qds != null) qds.close();
        }

        return populateObjects (rows);

    }



    /** Method to do inserts */
    public static ObjectKey doInsert( Criteria criteria ) throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                                                                                                                                                                                                                                               return BasePeer.doInsert( criteria );
    }

    /** 
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Criteria) method.  It will take care of 
     * the connection details internally. 
     */
    public static ObjectKey doInsert( Criteria criteria, DBConnection dbCon ) 
        throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                                                                                                                                                                                                                                               return BasePeer.doInsert( criteria, dbCon );
    }

    /** Add all the columns needed to create a new object */
    public static void addSelectColumns (Criteria criteria) throws Exception
    {
            criteria.addSelectColumn( ID );
            criteria.addSelectColumn( LOCATION );
            criteria.addSelectColumn( SITE );
            criteria.addSelectColumn( CONTENT_TYPE );
            criteria.addSelectColumn( TITLE );
            criteria.addSelectColumn( DESCRIPTION );
            criteria.addSelectColumn( IMAGE_FK );
            criteria.addSelectColumn( SOURCE );
            criteria.addSelectColumn( DATE_FOUND );
            criteria.addSelectColumn( LAST_UPDATED );
            criteria.addSelectColumn( COPYRIGHT );
            criteria.addSelectColumn( CATEGORY_FK );
            criteria.addSelectColumn( SUBSCRIBED );
            criteria.addSelectColumn( INDEXED );
            criteria.addSelectColumn( INITIALIZED );
            criteria.addSelectColumn( PUBLISHER );
            criteria.addSelectColumn( CREATOR );
        }


    /** 
     * Create a new object of type cls from a resultset row starting
     * from a specified offset.  This is done so that you can select
     * other rows than just those needed for this object.  You may
     * for example want to create two objects from the same row.
     */
    public static Channel row2Object (Record row, 
                                              int offset, 
                                              Class cls ) 
        throws Exception
    {
        Channel obj = (Channel)cls.newInstance();
        populateObject(row, offset, obj);
                    obj.setModified(false);
                obj.setNew(false);

        return obj;
    }

    /** 
     * Populates an object from a resultset row starting
     * from a specified offset.  This is done so that you can select
     * other rows than just those needed for this object.  You may
     * for example want to create two objects from the same row.
     */
    public static void populateObject (Record row, 
                                       int offset, 
                                       Channel obj ) 
        throws Exception
    {
                                                        obj.setId(
                new NumberKey(row.getValue(offset+0).asBigDecimal()));
                                                                            obj.setLocation(row.getValue(offset+1).asString());
                                                                            obj.setSite(row.getValue(offset+2).asString());
                                                                            obj.setContentType(row.getValue(offset+3).asString());
                                                                            obj.setTitle(row.getValue(offset+4).asString());
                                                                            obj.setDescription(row.getValue(offset+5).asString());
                                                                            obj.setImageFk(
                new NumberKey(row.getValue(offset+6).asBigDecimal()));
                                                                            obj.setSource(row.getValue(offset+7).asString());
                                                                            obj.setDateFound(row.getValue(offset+8).asLong());
                                                                            obj.setLastUpdated(row.getValue(offset+9).asLong());
                                                                            obj.setCopyright(row.getValue(offset+10).asString());
                                                                            obj.setCategoryFk(
                new NumberKey(row.getValue(offset+11).asBigDecimal()));
                                                                            obj.setSubscribed(row.getValue(offset+12).asInt());
                                                                            obj.setIndexed(row.getValue(offset+13).asInt());
                                                                            obj.setInitialized(row.getValue(offset+14).asInt());
                                                                            obj.setPublisher(row.getValue(offset+15).asString());
                                                                            obj.setCreator(row.getValue(offset+16).asString());
                                        }

    /** Method to do selects */
    public static Vector doSelect( Criteria criteria ) throws Exception
    {
        return populateObjects( doSelectVillageRecords(criteria) ); 
    }


    /** Method to do selects within a transaction */
    public static Vector doSelect( Criteria criteria, 
                                   DBConnection dbCon ) 
        throws Exception
    {
        return populateObjects( doSelectVillageRecords(criteria, dbCon) ); 
    }

    /** 
     * Grabs the raw Village records to be formed into objects.
     * This method handles connections internally.  The Record objects
     * returned by this method should be considered readonly.  Do not
     * alter the data and call save(), your results may vary, but are
     * certainly likely to result in hard to track MT bugs.
     */
    public static Vector doSelectVillageRecords( Criteria criteria ) 
        throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
            if (criteria.getSelectColumns().size() == 0)
        {
            addSelectColumns ( criteria );
        }

                                                                                                                                                                                                                                                   
        // BasePeer returns a Vector of Value (Village) arrays.  The array
        // order follows the order columns were placed in the Select clause.
        return BasePeer.doSelect(criteria);
    }


    /** 
     * Grabs the raw Village records to be formed into objects.
     * This method should be used for transactions 
     */
    public static Vector doSelectVillageRecords( Criteria criteria, 
                                                 DBConnection dbCon ) 
        throws Exception
    {
        if (criteria.getSelectColumns().size() == 0)
        {
            addSelectColumns ( criteria );
        }

                                                                                                                                                                                                                                                   
        // BasePeer returns a Vector of Value (Village) arrays.  The array
        // order follows the order columns were placed in the Select clause.
        return BasePeer.doSelect(criteria, dbCon);
    }

    /** 
     * The returned vector will contain objects of the default type or
     * objects that inherit from the default.
     */
    public static Vector populateObjects(Vector records) 
        throws Exception
    {
        Vector results = new Vector(records.size());

        // populate the object(s)
        for ( int i=0; i<records.size(); i++ )
        {
            Record row = (Record)records.elementAt(i);
            results.add(ChannelPeer.row2Object(row, 1,
                ChannelPeer.getOMClass()));
        }
        return results;
    }
 

    /** 
     * The class that the Peer will make instances of. 
     * If the BO is abstract then you must implement this method
     * in the BO.
     */
    public static Class getOMClass() 
        throws Exception
    {
            return CLASS_DEFAULT;
        }


    /**
     * Method to do updates. 
     *
     * @param Criteria object containing data that is used to create the UPDATE statement.
     */
    public static void doUpdate(Criteria criteria) throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
            Criteria selectCriteria = new
            Criteria(mapBuilder.getDatabaseMap().getName(), 2);
                                selectCriteria.put( ID, criteria.remove(ID) );
                                                                                                                                                                                                                                                                                                                                                                                                       BasePeer.doUpdate( selectCriteria, criteria );
    }

    /** 
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.  It will take care of 
     * the connection details internally. 
     *
     * @param Criteria object containing data that is used to create the UPDATE statement.
     */
    public static void doUpdate(Criteria criteria, DBConnection dbCon) throws Exception
    {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
            Criteria selectCriteria = new
            Criteria(mapBuilder.getDatabaseMap().getName(), 2);
                                selectCriteria.put( ID, criteria.remove(ID) );
                                                                                                                                                                                                                                                                                                                                                                                                       BasePeer.doUpdate( selectCriteria, criteria, dbCon );
     }

    /** 
     * Method to do deletes.
     *
     * @param Criteria object containing data that is used DELETE from database.
     */
     public static void doDelete(Criteria criteria) throws Exception
     {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                                                                                                                                                                                                                                                BasePeer.doDelete ( criteria );
     }

    /** 
     * Method to do deletes.  This method is to be used during a transaction,
     * otherwise use the doDelete(Criteria) method.  It will take care of 
     * the connection details internally. 
     *
     * @param Criteria object containing data that is used DELETE from database.
     */
     public static void doDelete(Criteria criteria, DBConnection dbCon) throws Exception
     {
            criteria.setDbName(mapBuilder.getDatabaseMap().getName());
                                                                                                                                                                                                                                                                BasePeer.doDelete ( criteria, dbCon );
     }

    /** Method to do inserts */
    public static void doInsert( Channel obj ) throws Exception
    {
                doInsert(buildCriteria(obj));
                obj.setNew(false);
    }

    /**
     * @param obj the data object to update in the database.
     */
    public static void doUpdate(Channel obj) throws Exception
    {
        doUpdate(buildCriteria(obj));
    }
    /**
     * @param obj the data object to delete in the database.
     */
    public static void doDelete(Channel obj) throws Exception
    {
        doDelete(buildCriteria(obj));
    }

    /** 
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Channel) method.  It will take 
     * care of the connection details internally. 
     *
     * @param obj the data object to insert into the database.
     */
    public static void doInsert( Channel obj, DBConnection dbCon) throws Exception
    {
                doInsert(buildCriteria(obj), dbCon);
                obj.setNew(false);
    }

    /**
     * Method to do update.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Channel) method.  It will take 
     * care of the connection details internally. 
     *
     * @param obj the data object to update in the database.
     */
    public static void doUpdate(Channel obj, DBConnection dbCon) throws Exception
    {
        doUpdate(buildCriteria(obj), dbCon);
    }
    /**
     * Method to delete.  This method is to be used during a transaction,
     * otherwise use the doDelete(Channel) method.  It will take 
     * care of the connection details internally. 
     *
     * @param obj the data object to delete in the database.
     */
    public static void doDelete(Channel obj, DBConnection dbCon) throws Exception
    {
        doDelete(buildCriteria(obj), dbCon);
    }

    /** Build a Criteria object from the data object for this peer */
    public static Criteria buildCriteria( Channel obj )
    {
        Criteria criteria = new Criteria();
                                criteria.add( ID, obj.getId() );
                                criteria.add( LOCATION, obj.getLocation() );
                                criteria.add( SITE, obj.getSite() );
                                criteria.add( CONTENT_TYPE, obj.getContentType() );
                                criteria.add( TITLE, obj.getTitle() );
                                criteria.add( DESCRIPTION, obj.getDescription() );
                                criteria.add( IMAGE_FK, obj.getImageFk() );
                                criteria.add( SOURCE, obj.getSource() );
                                criteria.add( DATE_FOUND, obj.getDateFound() );
                                criteria.add( LAST_UPDATED, obj.getLastUpdated() );
                                criteria.add( COPYRIGHT, obj.getCopyright() );
                                criteria.add( CATEGORY_FK, obj.getCategoryFk() );
                                criteria.add( SUBSCRIBED, obj.getSubscribed() );
                                criteria.add( INDEXED, obj.getIndexed() );
                                criteria.add( INITIALIZED, obj.getInitialized() );
                                criteria.add( PUBLISHER, obj.getPublisher() );
                                criteria.add( CREATOR, obj.getCreator() );
                return criteria;
    }

    /** 
     * Retrieve a single object by pk
     *
     * @param ObjectKey pk
     */
    public static Channel retrieveByPK( ObjectKey pk )
        throws Exception
    {
        DBConnection db = null;
        Channel retVal = null;
       try
        {
           db = TurbineDB.getConnection( mapBuilder.getDatabaseMap().getName() );
           retVal = retrieveByPK( pk, db );
        }
        finally
        {
           if (db != null)
              TurbineDB.releaseConnection(db);
        }
        return(retVal);
    }

    /** 
     * Retrieve a single object by pk
     *
     * @param ObjectKey pk
     * @param DBConnection dbcon
     */
    public static Channel retrieveByPK( ObjectKey pk, DBConnection dbcon )
        throws Exception
    {

        Criteria criteria = new Criteria();
            criteria.add( ID, pk );
        Vector v = doSelect(criteria, dbcon);
        if ( v.size() != 1)
        {
            throw new Exception("Failed to select one and only one row.");
        }
        else
        {
            return (Channel)v.firstElement();
        }
    }



 

      
        
                       
     
          


   /**
    * selects a collection of Channel objects pre-filled with their
    * Image objects.
    */
    protected static Vector doSelectJoinImage(Criteria c)
        throws Exception
    {
         c.setDbName(mapBuilder.getDatabaseMap().getName());

        ChannelPeer.addSelectColumns(c);
        int offset = numColumns + 1;
        ImagePeer.addSelectColumns(c);


                  c.addJoin(ChannelPeer.IMAGE_FK,
            ImagePeer.ID);
     



                                                                                                                                                                                                                                                           
        Vector rows = BasePeer.doSelect(c);
        Vector results = new Vector();

        for (int i=0; i<rows.size(); i++)
        {
            Record row = (Record)rows.elementAt(i);

            Class omClass = ChannelPeer.getOMClass();

            Channel obj1 = (Channel)ChannelPeer
                .row2Object( row, 1, omClass);


             omClass = ImagePeer.getOMClass();
            Image obj2 = (Image)ImagePeer
                .row2Object(row, offset, omClass);
            
            boolean newObject = true;
            for (int j=0; j<results.size(); j++)
            {
                Channel temp_obj1 = (Channel)results.elementAt(j);
                Image temp_obj2 = temp_obj1.getImage();
                if ( temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey() ) )
                {
                    newObject = false;
                    temp_obj2.addChannel(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initChannels();
                obj2.addChannel(obj1);
            }
            results.add(obj1);

        }

        return results;
    }
         
                       
     
          


   /**
    * selects a collection of Channel objects pre-filled with their
    * Category objects.
    */
    protected static Vector doSelectJoinCategory(Criteria c)
        throws Exception
    {
         c.setDbName(mapBuilder.getDatabaseMap().getName());

        ChannelPeer.addSelectColumns(c);
        int offset = numColumns + 1;
        CategoryPeer.addSelectColumns(c);


                  c.addJoin(ChannelPeer.CATEGORY_FK,
            CategoryPeer.ID);
     



                                                                                                                                                                                                                                                           
        Vector rows = BasePeer.doSelect(c);
        Vector results = new Vector();

        for (int i=0; i<rows.size(); i++)
        {
            Record row = (Record)rows.elementAt(i);

            Class omClass = ChannelPeer.getOMClass();

            Channel obj1 = (Channel)ChannelPeer
                .row2Object( row, 1, omClass);


             omClass = CategoryPeer.getOMClass();
            Category obj2 = (Category)CategoryPeer
                .row2Object(row, offset, omClass);
            
            boolean newObject = true;
            for (int j=0; j<results.size(); j++)
            {
                Channel temp_obj1 = (Channel)results.elementAt(j);
                Category temp_obj2 = temp_obj1.getCategory();
                if ( temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey() ) )
                {
                    newObject = false;
                    temp_obj2.addChannel(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initChannels();
                obj2.addChannel(obj1);
            }
            results.add(obj1);

        }

        return results;
    }
    

  


    /** 
     * Returns the TableMap related to this peer.  This method is not 
     * needed for general use but a specific application could have a
     * need.
     */
    protected static TableMap getTableMap()
    {
        return mapBuilder.getDatabaseMap().getTable(TABLE_NAME);
    }     
 

}

