package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Channel 
 */
public abstract class BaseChannel extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the location field */
    private String location;
          /** the value for the site field */
    private String site;
          /** the value for the content_type field */
    private String content_type;
          /** the value for the title field */
    private String title;
          /** the value for the description field */
    private String description;
          /** the value for the image_fk field */
    private NumberKey image_fk;
          /** the value for the source field */
    private String source;
          /** the value for the date_found field */
    private long date_found;
          /** the value for the last_updated field */
    private long last_updated;
          /** the value for the copyright field */
    private String copyright;
          /** the value for the category_fk field */
    private NumberKey category_fk;
                              /** the value for the subscribed field */
    private int subscribed=0;
                              /** the value for the indexed field */
    private int indexed=0;
                              /** the value for the initialized field */
    private int initialized=0;
          /** the value for the publisher field */
    private String publisher;
          /** the value for the creator field */
    private String creator;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                                                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) throws Exception
     {
  
       
        
                
          // update associated Monitor
          if (collMonitors != null )
          {
              for (int i=0; i<collMonitors.size(); i++)
              {
                  ((Monitor)collMonitors.get(i))
                      .setChannelFk(v);
              }
          }
       

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) throws Exception
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the Location
     * @return String
     */
     public String getLocation()
     {
          return location;
     }

                            
    /**
     * Set the value of Location
     */
     public void setLocation(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.location, v) )
        {
                       this.location = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Site
     * @return String
     */
     public String getSite()
     {
          return site;
     }

                            
    /**
     * Set the value of Site
     */
     public void setSite(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.site, v) )
        {
                       this.site = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the ContentType
     * @return String
     */
     public String getContentType()
     {
          return content_type;
     }

                            
    /**
     * Set the value of ContentType
     */
     public void setContentType(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.content_type, v) )
        {
                       this.content_type = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Title
     * @return String
     */
     public String getTitle()
     {
          return title;
     }

                            
    /**
     * Set the value of Title
     */
     public void setTitle(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.title, v) )
        {
                       this.title = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Description
     * @return String
     */
     public String getDescription()
     {
          return description;
     }

                            
    /**
     * Set the value of Description
     */
     public void setDescription(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.description, v) )
        {
                       this.description = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the ImageFk
     * @return NumberKey
     */
     public NumberKey getImageFk()
     {
          return image_fk;
     }

                                    
    /**
     * Set the value of ImageFk
     */
     public void setImageFk(NumberKey v ) throws Exception
     {
              aImage = null;
  
  

         if ( !ObjectUtils.equals(this.image_fk, v) )
        {
                       if (this.image_fk == null)
            {
                this.image_fk = new NumberKey(v);
            }
            else
            {
                this.image_fk.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of ImageFk as a string.
    */
    public void setImageFk(String v ) throws Exception
    {
         setImageFk(new NumberKey(v));
    }
  
    /**
     * Get the Source
     * @return String
     */
     public String getSource()
     {
          return source;
     }

                            
    /**
     * Set the value of Source
     */
     public void setSource(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.source, v) )
        {
                       this.source = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the DateFound
     * @return long
     */
     public long getDateFound()
     {
          return date_found;
     }

                            
    /**
     * Set the value of DateFound
     */
     public void setDateFound(long v ) 
     {
  
  

         if (this.date_found != v)
        {
                       this.date_found = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the LastUpdated
     * @return long
     */
     public long getLastUpdated()
     {
          return last_updated;
     }

                            
    /**
     * Set the value of LastUpdated
     */
     public void setLastUpdated(long v ) 
     {
  
  

         if (this.last_updated != v)
        {
                       this.last_updated = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Copyright
     * @return String
     */
     public String getCopyright()
     {
          return copyright;
     }

                            
    /**
     * Set the value of Copyright
     */
     public void setCopyright(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.copyright, v) )
        {
                       this.copyright = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the CategoryFk
     * @return NumberKey
     */
     public NumberKey getCategoryFk()
     {
          return category_fk;
     }

                                    
    /**
     * Set the value of CategoryFk
     */
     public void setCategoryFk(NumberKey v ) throws Exception
     {
              aCategory = null;
  
  

         if ( !ObjectUtils.equals(this.category_fk, v) )
        {
                       if (this.category_fk == null)
            {
                this.category_fk = new NumberKey(v);
            }
            else
            {
                this.category_fk.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of CategoryFk as a string.
    */
    public void setCategoryFk(String v ) throws Exception
    {
         setCategoryFk(new NumberKey(v));
    }
  
    /**
     * Get the Subscribed
     * @return int
     */
     public int getSubscribed()
     {
          return subscribed;
     }

                            
    /**
     * Set the value of Subscribed
     */
     public void setSubscribed(int v ) 
     {
  
  

         if (this.subscribed != v)
        {
                       this.subscribed = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Indexed
     * @return int
     */
     public int getIndexed()
     {
          return indexed;
     }

                            
    /**
     * Set the value of Indexed
     */
     public void setIndexed(int v ) 
     {
  
  

         if (this.indexed != v)
        {
                       this.indexed = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Initialized
     * @return int
     */
     public int getInitialized()
     {
          return initialized;
     }

                            
    /**
     * Set the value of Initialized
     */
     public void setInitialized(int v ) 
     {
  
  

         if (this.initialized != v)
        {
                       this.initialized = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Publisher
     * @return String
     */
     public String getPublisher()
     {
          return publisher;
     }

                            
    /**
     * Set the value of Publisher
     */
     public void setPublisher(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.publisher, v) )
        {
                       this.publisher = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Creator
     * @return String
     */
     public String getCreator()
     {
          return creator;
     }

                            
    /**
     * Set the value of Creator
     */
     public void setCreator(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.creator, v) )
        {
                       this.creator = v;
                      setModified(true);
        }
     }

  

 
 
   
             
   
   
    private Image aImage;

    /**
     * Declares an association between this object and a Image object
     *
     * @param Image v
     */
    public void setImage(Image v) throws Exception
    {
           setImageFk(v.getId());
           aImage = v;
    }

                     
    public Image getImage() throws Exception
    {
        if ( aImage==null && (!ObjectUtils.equals(this.image_fk, null)) )
        {
            aImage = ImagePeer.retrieveByPK(this.image_fk);
            // The following can be used instead of the line above to
            // guarantee the related object contains a reference
            // to this object, but this level of coupling 
            // may be undesirable in many circumstances.
            // As it can lead to a db query with many results that may
            // never be used.  
            // Image obj = ImagePeer.retrieveByPK(this.image_fk);
            // obj.addChannels(this);
        }
        return aImage;
    }


    /**
     * Provides convenient way to set a relationship based on a 
     * ObjectKey.  e.g. 
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setImageKey(ObjectKey key) throws Exception
    {
            setImageFk((NumberKey)key);        
        }

 
   
             
   
   
    private Category aCategory;

    /**
     * Declares an association between this object and a Category object
     *
     * @param Category v
     */
    public void setCategory(Category v) throws Exception
    {
           setCategoryFk(v.getId());
           aCategory = v;
    }

                     
    public Category getCategory() throws Exception
    {
        if ( aCategory==null && (!ObjectUtils.equals(this.category_fk, null)) )
        {
            aCategory = CategoryPeer.retrieveByPK(this.category_fk);
            // The following can be used instead of the line above to
            // guarantee the related object contains a reference
            // to this object, but this level of coupling 
            // may be undesirable in many circumstances.
            // As it can lead to a db query with many results that may
            // never be used.  
            // Category obj = CategoryPeer.retrieveByPK(this.category_fk);
            // obj.addChannels(this);
        }
        return aCategory;
    }


    /**
     * Provides convenient way to set a relationship based on a 
     * ObjectKey.  e.g. 
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setCategoryKey(ObjectKey key) throws Exception
    {
            setCategoryFk((NumberKey)key);        
        }

    
                
      
    /**
     * Collection to store aggregation of collMonitors
     */
    protected Vector collMonitors;
    /**
     * Temporary storage of collMonitors to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
//    private Vector tempcollMonitors;

    protected void initMonitors()
    {
        if (collMonitors == null)
            collMonitors = new Vector();
    }

    /**
     * Method called to associate a Monitor object to this object
     * through the Monitor foreign key attribute
     *
     * @param Monitor l
     */
    public void addMonitor(Monitor l) throws Exception
    {
        /*
        if (collMonitors == null)
        {
            if (tempcollMonitors == null)
            {
                tempcollMonitors = new Vector();
            }
            tempcollMonitors.add(l);
        }
        else
        {
            collMonitors.add(l);
        }
        */
        getMonitors().add(l);
        l.setChannel((Channel)this);
    }

    /**
     * The criteria used to select the current contents of collMonitors
     */
    private Criteria lastMonitorsCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of 
     * getMonitors(new Criteria())
     */
    public Vector getMonitors() throws Exception
    {
        if (collMonitors == null)
        {
            collMonitors = getMonitors(new Criteria(10));
        }
        return collMonitors;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection. 
     * Otherwise if this Channel has previously
     * been saved, it will retrieve related Monitors from storage.
     * If this Channel is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object. 
     */
    public Vector getMonitors(Criteria criteria) throws Exception
    {
        if (collMonitors == null)
        {
            if ( isNew() ) 
            {
               collMonitors = new Vector();       
            } 
            else
            {
                   criteria.add(MonitorPeer.CHANNEL_FK, getId() );               
                   collMonitors = MonitorPeer.doSelect(criteria);
            }
/*
            if (tempcollMonitors != null)
            {
                for (int i=0; i<tempcollMonitors.size(); i++)
                {
                    collMonitors.add(tempcollMonitors.get(i));
                }
                tempcollMonitors = null;
            }
*/
        }
        else
        {
           // criteria has no effect for a new object
            if ( !isNew() ) 
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                   criteria.add(MonitorPeer.CHANNEL_FK, getId() );               
                   if ( !lastMonitorsCriteria.equals(criteria)  )
                {
                    collMonitors = MonitorPeer.doSelect(criteria);  
                }
            }
        }
        lastMonitorsCriteria = criteria; 

        return collMonitors;
    }
   

        
      
         
          
                    
                
        
        
      



     
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Location");
            fieldNames_.add("Site");
            fieldNames_.add("ContentType");
            fieldNames_.add("Title");
            fieldNames_.add("Description");
            fieldNames_.add("ImageFk");
            fieldNames_.add("Source");
            fieldNames_.add("DateFound");
            fieldNames_.add("LastUpdated");
            fieldNames_.add("Copyright");
            fieldNames_.add("CategoryFk");
            fieldNames_.add("Subscribed");
            fieldNames_.add("Indexed");
            fieldNames_.add("Initialized");
            fieldNames_.add("Publisher");
            fieldNames_.add("Creator");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("Location"))
	{
	  	    return getLocation();
	  	}
            if (name.equals("Site"))
	{
	  	    return getSite();
	  	}
            if (name.equals("ContentType"))
	{
	  	    return getContentType();
	  	}
            if (name.equals("Title"))
	{
	  	    return getTitle();
	  	}
            if (name.equals("Description"))
	{
	  	    return getDescription();
	  	}
            if (name.equals("ImageFk"))
	{
	  	    return getImageFk();
	  	}
            if (name.equals("Source"))
	{
	  	    return getSource();
	  	}
            if (name.equals("DateFound"))
	{
	  	    return new Long(getDateFound());
	  	}
            if (name.equals("LastUpdated"))
	{
	  	    return new Long(getLastUpdated());
	  	}
            if (name.equals("Copyright"))
	{
	  	    return getCopyright();
	  	}
            if (name.equals("CategoryFk"))
	{
	  	    return getCategoryFk();
	  	}
            if (name.equals("Subscribed"))
	{
	  	    return new Integer(getSubscribed());
	  	}
            if (name.equals("Indexed"))
	{
	  	    return new Integer(getIndexed());
	  	}
            if (name.equals("Initialized"))
	{
	  	    return new Integer(getInitialized());
	  	}
            if (name.equals("Publisher"))
	{
	  	    return getPublisher();
	  	}
            if (name.equals("Creator"))
	{
	  	    return getCreator();
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(ChannelPeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(ChannelPeer.LOCATION ))
	    {
	  	    return getLocation();
	  	}
            if (name.equals(ChannelPeer.SITE ))
	    {
	  	    return getSite();
	  	}
            if (name.equals(ChannelPeer.CONTENT_TYPE ))
	    {
	  	    return getContentType();
	  	}
            if (name.equals(ChannelPeer.TITLE ))
	    {
	  	    return getTitle();
	  	}
            if (name.equals(ChannelPeer.DESCRIPTION ))
	    {
	  	    return getDescription();
	  	}
            if (name.equals(ChannelPeer.IMAGE_FK ))
	    {
	  	    return getImageFk();
	  	}
            if (name.equals(ChannelPeer.SOURCE ))
	    {
	  	    return getSource();
	  	}
            if (name.equals(ChannelPeer.DATE_FOUND ))
	    {
	  	    return new Long(getDateFound());
	  	}
            if (name.equals(ChannelPeer.LAST_UPDATED ))
	    {
	  	    return new Long(getLastUpdated());
	  	}
            if (name.equals(ChannelPeer.COPYRIGHT ))
	    {
	  	    return getCopyright();
	  	}
            if (name.equals(ChannelPeer.CATEGORY_FK ))
	    {
	  	    return getCategoryFk();
	  	}
            if (name.equals(ChannelPeer.SUBSCRIBED ))
	    {
	  	    return new Integer(getSubscribed());
	  	}
            if (name.equals(ChannelPeer.INDEXED ))
	    {
	  	    return new Integer(getIndexed());
	  	}
            if (name.equals(ChannelPeer.INITIALIZED ))
	    {
	  	    return new Integer(getInitialized());
	  	}
            if (name.equals(ChannelPeer.PUBLISHER ))
	    {
	  	    return getPublisher();
	  	}
            if (name.equals(ChannelPeer.CREATOR ))
	    {
	  	    return getCreator();
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getLocation();
	  	}
            if ( pos == 2 )
	{
	  	    return getSite();
	  	}
            if ( pos == 3 )
	{
	  	    return getContentType();
	  	}
            if ( pos == 4 )
	{
	  	    return getTitle();
	  	}
            if ( pos == 5 )
	{
	  	    return getDescription();
	  	}
            if ( pos == 6 )
	{
	  	    return getImageFk();
	  	}
            if ( pos == 7 )
	{
	  	    return getSource();
	  	}
            if ( pos == 8 )
	{
	  	    return new Long(getDateFound());
	  	}
            if ( pos == 9 )
	{
	  	    return new Long(getLastUpdated());
	  	}
            if ( pos == 10 )
	{
	  	    return getCopyright();
	  	}
            if ( pos == 11 )
	{
	  	    return getCategoryFk();
	  	}
            if ( pos == 12 )
	{
	  	    return new Integer(getSubscribed());
	  	}
            if ( pos == 13 )
	{
	  	    return new Integer(getIndexed());
	  	}
            if ( pos == 14 )
	{
	  	    return new Integer(getInitialized());
	  	}
            if ( pos == 15 )
	{
	  	    return getPublisher();
	  	}
            if ( pos == 16 )
	{
	  	    return getCreator();
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(ChannelPeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                ChannelPeer.doInsert((Channel)this, dbCon);
            }
            else
            {
                ChannelPeer.doUpdate((Channel)this, dbCon);
                setNew(false);
            }
        }

                                    
                
          if (collMonitors != null )
          {
              for (int i=0; i<collMonitors.size(); i++)
              {
                  ((Monitor)collMonitors.get(i)).save(dbCon);
              }
          }
                  alreadyInSave = false;
      }
      }


                        
    
    

        /** 
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id) 
        throws Exception {
         setId((NumberKey)id);
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws Exception
    {
        setId(new NumberKey(key) );
    }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
        return getId();
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Channel copy() throws Exception
    {
        Channel copyObj = new Channel();
        copyObj.setId(id);
        copyObj.setLocation(location);
        copyObj.setSite(site);
        copyObj.setContentType(content_type);
        copyObj.setTitle(title);
        copyObj.setDescription(description);
        copyObj.setImageFk(image_fk);
        copyObj.setSource(source);
        copyObj.setDateFound(date_found);
        copyObj.setLastUpdated(last_updated);
        copyObj.setCopyright(copyright);
        copyObj.setCategoryFk(category_fk);
        copyObj.setSubscribed(subscribed);
        copyObj.setIndexed(indexed);
        copyObj.setInitialized(initialized);
        copyObj.setPublisher(publisher);
        copyObj.setCreator(creator);


                                    
                
         List v = copyObj.getMonitors();
         for (int i=0; i<v.size(); i++)
         {
             ((Persistent)v.get(i)).setNew(true);
         }
              
            copyObj.setId((NumberKey)null);
                                                                            return copyObj;
    }
}

