package org.openprivacy.reptile.om;


// JDK classes
import java.util.*;
import java.math.*;

// Turbine classes
import org.apache.turbine.om.*;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.StringUtils;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.db.pool.DBConnection;

/** 
 * This class was autogenerated by Torque on:
 *
 * [Mon Jul 01 17:54:11 PDT 2002]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to Article 
 */
public abstract class BaseArticle extends BaseObject
    implements Retrievable
{
          /** the value for the id field */
    private NumberKey id;
          /** the value for the location field */
    private String location;
          /** the value for the channel field */
    private String channel;
          /** the value for the title field */
    private String title;
          /** the value for the description field */
    private String description;
          /** the value for the copyright field */
    private String copyright;
          /** the value for the dc_creator field */
    private String dc_creator;
          /** the value for the dc_subject field */
    private String dc_subject;
          /** the value for the date_found field */
    private long date_found;
          /** the value for the last_updated field */
    private long last_updated;
                              /** the value for the marked_read field */
    private int marked_read=0;
  

      /**
     * Get the Id
     * @return NumberKey
     */
     public NumberKey getId()
     {
          return id;
     }

                            
    /**
     * Set the value of Id
     */
     public void setId(NumberKey v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.id, v) )
        {
                       if (this.id == null)
            {
                this.id = new NumberKey(v);
            }
            else
            {
                this.id.setValue(v);
            }
                      setModified(true);
        }
     }

     /**
    * Set the value of Id as a string.
    */
    public void setId(String v ) 
    {
         setId(new NumberKey(v));
    }
  
    /**
     * Get the Location
     * @return String
     */
     public String getLocation()
     {
          return location;
     }

                            
    /**
     * Set the value of Location
     */
     public void setLocation(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.location, v) )
        {
                       this.location = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Channel
     * @return String
     */
     public String getChannel()
     {
          return channel;
     }

                            
    /**
     * Set the value of Channel
     */
     public void setChannel(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.channel, v) )
        {
                       this.channel = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Title
     * @return String
     */
     public String getTitle()
     {
          return title;
     }

                            
    /**
     * Set the value of Title
     */
     public void setTitle(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.title, v) )
        {
                       this.title = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Description
     * @return String
     */
     public String getDescription()
     {
          return description;
     }

                            
    /**
     * Set the value of Description
     */
     public void setDescription(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.description, v) )
        {
                       this.description = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the Copyright
     * @return String
     */
     public String getCopyright()
     {
          return copyright;
     }

                            
    /**
     * Set the value of Copyright
     */
     public void setCopyright(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.copyright, v) )
        {
                       this.copyright = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the DcCreator
     * @return String
     */
     public String getDcCreator()
     {
          return dc_creator;
     }

                            
    /**
     * Set the value of DcCreator
     */
     public void setDcCreator(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.dc_creator, v) )
        {
                       this.dc_creator = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the DcSubject
     * @return String
     */
     public String getDcSubject()
     {
          return dc_subject;
     }

                            
    /**
     * Set the value of DcSubject
     */
     public void setDcSubject(String v ) 
     {
  
  

         if ( !ObjectUtils.equals(this.dc_subject, v) )
        {
                       this.dc_subject = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the DateFound
     * @return long
     */
     public long getDateFound()
     {
          return date_found;
     }

                            
    /**
     * Set the value of DateFound
     */
     public void setDateFound(long v ) 
     {
  
  

         if (this.date_found != v)
        {
                       this.date_found = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the LastUpdated
     * @return long
     */
     public long getLastUpdated()
     {
          return last_updated;
     }

                            
    /**
     * Set the value of LastUpdated
     */
     public void setLastUpdated(long v ) 
     {
  
  

         if (this.last_updated != v)
        {
                       this.last_updated = v;
                      setModified(true);
        }
     }

  
    /**
     * Get the MarkedRead
     * @return int
     */
     public int getMarkedRead()
     {
          return marked_read;
     }

                            
    /**
     * Set the value of MarkedRead
     */
     public void setMarkedRead(int v ) 
     {
  
  

         if (this.marked_read != v)
        {
                       this.marked_read = v;
                      setModified(true);
        }
     }

  

 
    
        
    
    private static Vector fieldNames_ = null;

    /**
     * Generate a list of field names.
     */
    public static synchronized List getFieldNames()
    {
      if (fieldNames_ == null)
      {
        fieldNames_ = new Vector();
            fieldNames_.add("Id");
            fieldNames_.add("Location");
            fieldNames_.add("Channel");
            fieldNames_.add("Title");
            fieldNames_.add("Description");
            fieldNames_.add("Copyright");
            fieldNames_.add("DcCreator");
            fieldNames_.add("DcSubject");
            fieldNames_.add("DateFound");
            fieldNames_.add("LastUpdated");
            fieldNames_.add("MarkedRead");
          }
      return fieldNames_;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.
     */
    public Object getByName(String name)
    {
            if (name.equals("Id"))
	{
	  	    return getId();
	  	}
            if (name.equals("Location"))
	{
	  	    return getLocation();
	  	}
            if (name.equals("Channel"))
	{
	  	    return getChannel();
	  	}
            if (name.equals("Title"))
	{
	  	    return getTitle();
	  	}
            if (name.equals("Description"))
	{
	  	    return getDescription();
	  	}
            if (name.equals("Copyright"))
	{
	  	    return getCopyright();
	  	}
            if (name.equals("DcCreator"))
	{
	  	    return getDcCreator();
	  	}
            if (name.equals("DcSubject"))
	{
	  	    return getDcSubject();
	  	}
            if (name.equals("DateFound"))
	{
	  	    return new Long(getDateFound());
	  	}
            if (name.equals("LastUpdated"))
	{
	  	    return new Long(getLastUpdated());
	  	}
            if (name.equals("MarkedRead"))
	{
	  	    return new Integer(getMarkedRead());
	  	}
            return null; 
    }
    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     */
    public Object getByPeerName(String name)
    {
            if (name.equals(ArticlePeer.ID ))
	    {
	  	    return getId();
	  	}
            if (name.equals(ArticlePeer.LOCATION ))
	    {
	  	    return getLocation();
	  	}
            if (name.equals(ArticlePeer.CHANNEL ))
	    {
	  	    return getChannel();
	  	}
            if (name.equals(ArticlePeer.TITLE ))
	    {
	  	    return getTitle();
	  	}
            if (name.equals(ArticlePeer.DESCRIPTION ))
	    {
	  	    return getDescription();
	  	}
            if (name.equals(ArticlePeer.COPYRIGHT ))
	    {
	  	    return getCopyright();
	  	}
            if (name.equals(ArticlePeer.DC_CREATOR ))
	    {
	  	    return getDcCreator();
	  	}
            if (name.equals(ArticlePeer.DC_SUBJECT ))
	    {
	  	    return getDcSubject();
	  	}
            if (name.equals(ArticlePeer.DATE_FOUND ))
	    {
	  	    return new Long(getDateFound());
	  	}
            if (name.equals(ArticlePeer.LAST_UPDATED ))
	    {
	  	    return new Long(getLastUpdated());
	  	}
            if (name.equals(ArticlePeer.MARKED_READ ))
	    {
	  	    return new Integer(getMarkedRead());
	  	}
            return null; 
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     */
    public Object getByPosition(int pos)
    {
            if ( pos == 0 )
	{
	  	    return getId();
	  	}
            if ( pos == 1 )
	{
	  	    return getLocation();
	  	}
            if ( pos == 2 )
	{
	  	    return getChannel();
	  	}
            if ( pos == 3 )
	{
	  	    return getTitle();
	  	}
            if ( pos == 4 )
	{
	  	    return getDescription();
	  	}
            if ( pos == 5 )
	{
	  	    return getCopyright();
	  	}
            if ( pos == 6 )
	{
	  	    return getDcCreator();
	  	}
            if ( pos == 7 )
	{
	  	    return getDcSubject();
	  	}
            if ( pos == 8 )
	{
	  	    return new Long(getDateFound());
	  	}
            if ( pos == 9 )
	{
	  	    return new Long(getLastUpdated());
	  	}
            if ( pos == 10 )
	{
	  	    return new Integer(getMarkedRead());
	  	}
                return null; 
    }

     	

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save() throws Exception
    {
             save(ArticlePeer.getMapBuilder()
                .getDatabaseMap().getName());
     }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     */
    public void save(String dbName) throws Exception
    {
        DBConnection dbCon = null;
         try
        {
            dbCon = BasePeer.beginTransaction(dbName);
            save(dbCon);
        }
        catch(Exception e)
        {
            BasePeer.rollBackTransaction(dbCon);
            throw e;
        }
        BasePeer.commitTransaction(dbCon);

     }

      // flag to prevent endless save loop, if this object is referenced
    // by another object which falls in this transaction.
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     */
    public void save(DBConnection dbCon) throws Exception
    {
        if (!alreadyInSave)
      {
        alreadyInSave = true;
          if (isModified())
        {
            if (isNew())
            {
                ArticlePeer.doInsert((Article)this, dbCon);
            }
            else
            {
                ArticlePeer.doUpdate((Article)this, dbCon);
                setNew(false);
            }
        }

              alreadyInSave = false;
      }
      }


                
    
    

        /** 
     * Set the PrimaryKey using ObjectKey.
     *
     * @param ObjectKey id
     */
    public void setPrimaryKey(ObjectKey id) 
         {
         setId((NumberKey)id);
    }

    /** 
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) 
    {
        setId(new NumberKey(key) );
    }



    /** 
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey() 
    {
        return getId();
    }

 
    /** 
     * get an id that differentiates this object from others
     * of its class.
     */
    public String getQueryKey() 
    {
        if (getPrimaryKey() == null)
        {
            return "";
        }
        else
        {
            return getPrimaryKey().toString();
        }
    }

    /** 
     * set an id that differentiates this object from others
     * of its class.
     */
    public void setQueryKey(String key) 
        throws Exception
    {
        setPrimaryKey(key);
    }

    /**
     * Makes a copy of this object.  
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public Article copy() throws Exception
    {
        Article copyObj = new Article();
        copyObj.setId(id);
        copyObj.setLocation(location);
        copyObj.setChannel(channel);
        copyObj.setTitle(title);
        copyObj.setDescription(description);
        copyObj.setCopyright(copyright);
        copyObj.setDcCreator(dc_creator);
        copyObj.setDcSubject(dc_subject);
        copyObj.setDateFound(date_found);
        copyObj.setLastUpdated(last_updated);
        copyObj.setMarkedRead(marked_read);


    
            copyObj.setId((NumberKey)null);
                                                    return copyObj;
    }
}

