package org.openprivacy.reptile.om;

// JDK classes
import java.util.*;

// Village classes
import com.workingdogs.village.*;

// Turbine classes
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import org.apache.turbine.util.db.pool.DBConnection;

// Local classes
import org.openprivacy.reptile.om.map.*;

import talon.util.*;

/** 
  * The skeleton for this class was autogenerated by Torque on:
  *
  * [Mon Nov 26 01:04:40 PST 2001]
  *
  *  You should add additional methods to this class to meet the
  *  application requirements.  This class will only be generated as
  *  long as it does not already exist in the output directory.
  */
public class ArticlePeer 
    extends org.openprivacy.reptile.om.BaseArticlePeer
{

    public static final int S_MARKED_UNREAD = 0;
    public static final int S_MARKED_READ = 1;

    /**
     * The maximum number of Article rows we should return at once.  This value
     * should be used in multiple places.  Specifically RSS 1.0 spec says that
     * an RSS channel should never have more than X items.  Also search results
     * should pay attention to this value.
     */
    public static final int S_ARTICLE_MAXROWS = 15;

    public static final int S_MAXROWS_DEFAULT = 0;
    
    /**
     * Get a channel by it's location return null if one wasn't found.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public static Article getArticleByLocation( String location ) throws Exception {
        
        Criteria criteria = new Criteria();

        criteria.add( ArticlePeer.LOCATION, location );

        criteria.addDescendingOrderByColumn( ArticlePeer.DATE_FOUND );
        
        Vector v = doSelect( criteria );

        if ( v.size() == 0 )
            return null;

        if ( v.size() == 1)
            return (Article)v.elementAt( 0 );

        throw new Exception( "Too many channels found.  Location column needs to be unique." );
        
    }

    /**
     * Update the title and description in the given location.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public static synchronized void updateArticle( String location,
                                                   String channelLocation,
                                                   String title,
                                                   String description ) throws Exception {

        Channel channel = ChannelPeer.getChannelByLocation( channelLocation );

        Article content = getArticleByLocation( location );

        if ( content == null )
            content = new Article();

        content.setLocation( location );
        content.setTitle( title );
        content.setDescription( description );
        content.setChannel( channelLocation );
        
        content.save();
        
    }

    /**
     * Get the number of channels in this peer.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public static int getCount() throws Exception {

        //Criteria crit = new Criteria().addAsColumn("count", "count(*)");

        //now get the count back...

        Vector v = BasePeer.executeQuery( "SELECT COUNT(*) FROM " + TABLE_NAME + ";" );

        Record record = (Record)v.elementAt( 0 );
        return record.getValue( 1 ).asInt();
        
    }

    /**
     * Search for and find content by their title.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public static Article[] searchByTitle( String query ) throws Exception {

        Criteria criteria = new Criteria();

        criteria.add( ArticlePeer.TITLE, (Object)query, Criteria.LIKE );

        criteria.addDescendingOrderByColumn( ArticlePeer.DATE_FOUND );
        
        return returnArticles( criteria );
        
    }

    /**
     * Search for and find content by their description.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public static Article[] searchByDescription( String query ) throws Exception {

        Criteria criteria = new Criteria();

        criteria.add( ArticlePeer.DESCRIPTION, (Object)query, Criteria.LIKE );

        criteria.addDescendingOrderByColumn( ArticlePeer.DATE_FOUND );
        
        return returnArticles( criteria );
        
    }

    /**
     * Search within the peers by title and description.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public static Article[] searchByTitleAndDescription( String query ) throws Exception {

        Criteria crit = new Criteria();

        Criteria.Criterion byTitle = crit.getNewCriterion( TITLE, query, Criteria.LIKE );
        Criteria.Criterion byDescription = crit.getNewCriterion( DESCRIPTION, query, Criteria.LIKE );

        //Need to execute an OR query...

        crit.add( byTitle.or( byDescription ) );

        crit.addDescendingOrderByColumn( ArticlePeer.DATE_FOUND );

        return returnArticles( crit );
        
    }

    /**
     * Search for all articles within the given channel but return only unread
     * items.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static Article[] searchByChannelUnreadOnly( String channel ) throws Exception {

        RuntimeUtil ru = new RuntimeUtil();
        
        //only return a fixed set of articles.  Note that this should be a safe
        //operation because Turbine/Torque should assure that the current DB
        //connection is only used by one thread at a time.
        BasePeer.executeStatement( "SET MAXROWS " + S_ARTICLE_MAXROWS );

        Criteria criteria = new Criteria();

        criteria.add( ArticlePeer.CHANNEL, channel );

        criteria.add( ArticlePeer.MARKED_READ, S_MARKED_UNREAD );
        
        criteria.addDescendingOrderByColumn( ArticlePeer.DATE_FOUND );

        Article[] articles = returnArticles( criteria );

         //set MAXROWS back to the default
        BasePeer.executeStatement( "SET MAXROWS " + S_MAXROWS_DEFAULT );

        ru.output();
        
        return articles;

    }
    
    /**
     * Given a vector of content... return it as an array of content.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    private static Article[] returnArticles( Criteria crit ) throws Exception {
        
        Vector v = doSelect( crit );

        //FIXME: don't do this.  instead we should return an empty array.
        //if ( v.size() == 0 )
        //    throw new Exception( "No content found.." );

        Article[] content = new Article[ v.size() ];

        v.copyInto( content );

        return content;

    }

    /**
     * Mark all subscriptions (articles in the DB) read.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void markAllSubscriptionsRead() throws Exception {

        //TODO: right now we are assuming that all articles in the DB are the
        //users subscriptions.  This might change in the future.

        Criteria selectCriteria = new Criteria();

        Criteria updateCriteria = new Criteria();

        selectCriteria.add( ArticlePeer.MARKED_READ, 0 );

        updateCriteria.add( ArticlePeer.MARKED_READ, 1 );

        doUpdate( selectCriteria, updateCriteria );

    }

    /**
     * Mark all subscriptions (articles in the DB) unread.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void markAllSubscriptionsUnread() throws Exception {

        //TODO: right now we are assuming that all articles in the DB are the
        //users subscriptions.  This might change in the future.

        Criteria selectCriteria = new Criteria();

        Criteria updateCriteria = new Criteria();

        selectCriteria.add( ArticlePeer.MARKED_READ, S_MARKED_READ );

        updateCriteria.add( ArticlePeer.MARKED_READ, S_MARKED_UNREAD );

        doUpdate( selectCriteria, updateCriteria );

    }

    /**
     * We provide a wrapper around doUpdate so that we can set the database
     * map, etc on the criteria prior to execution.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void doUpdate( Criteria selectCriteria,
                                 Criteria updateCriteria ) throws Exception {

        selectCriteria.setDbName( getMapBuilder().getDatabaseMap().getName() );

        updateCriteria.setDbName( getMapBuilder().getDatabaseMap().getName() );
        
        BasePeer.doUpdate( selectCriteria, updateCriteria ) ;
        
    }
    
}

