/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.metaupdate.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.util.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;
import org.apache.xalan.transformer.*;

import org.w3c.dom.*;

import javax.xml.transform.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.metaupdate.updates.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: MetaUpdateExtension.java,v 1.4 2002/02/26 09:17:55 burton Exp $
 */
public class MetaUpdateExtension {
    
    /**
     * Create a new  link.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: MetaUpdateExtension.java,v 1.4 2002/02/26 09:17:55 burton Exp $
     */
    public void channel( XSLProcessorContext context,
                         ElemExtensionCall elem ) {

        try { 

            //FIXME: make sure this meets the schema

            Node cn = context.getContextNode();

            TransformerImpl t = context.getTransformer();

            String uLocation = elem.getAttribute( "location", cn, t );

            String site = elem.getAttribute( "site", cn, t );

            String contentType = elem.getAttribute( "contentType", cn, t );

            String title = elem.getAttribute( "title", cn, t );

            String description = elem.getAttribute( "description", cn, t );

            new UpdateChannel().update( uLocation, site, contentType, title, description );
            
        } catch ( Throwable t ) {

            Log.error( t );
            
            t.printStackTrace();
            
        }

    }



    /**
     * <meta-update:image channel="{$location}"
     *                    site="{../rss:link}"
     *                    url="{rss:link}"
     *                    title="{rss:title}"
     *                    description="{rss:description}"/>
     * 
     * 
     * Update meta info for the given article/item.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void image( XSLProcessorContext context,
                       ElemExtensionCall elem ) {
                           
        try { 

            //FIXME: make sure this meets the schema

            Node cn = context.getContextNode();

            TransformerImpl t = context.getTransformer();

            String channel = elem.getAttribute( "channel", cn, t );

            String site = elem.getAttribute( "site", cn, t );

            String url = elem.getAttribute( "url", cn, t );

            String title = elem.getAttribute( "title", cn, t );

            String description = elem.getAttribute( "description", cn, t );

            new UpdateImage().update( channel, url, title, description );
            
        } catch ( Throwable t ) {

            Log.error( t );
            
            t.printStackTrace();
            
        }

    }

            
    /**
     * Update meta info for the given article/item.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void article( XSLProcessorContext context,
                         ElemExtensionCall elem ) {
        
        try { 

            Node cn = context.getContextNode();

            TransformerImpl t = context.getTransformer();
            
            //FIXME: make sure this meets the schema

            String uLocation = elem.getAttribute( "location", cn, t );

            String title = elem.getAttribute( "title", cn, t );

            String description = elem.getAttribute( "description", cn, t );
            
            String channelLocation = elem.getAttribute( "channel", cn, t );

            new UpdateArticle().update( uLocation, channelLocation, title, description );
            
        } catch ( Throwable t ) {

            Log.error( t );
            
            t.printStackTrace();
            
        }

    }
    
}
