/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.jxta.tasks;

import java.io.*;
import java.util.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.jxta.protocol.*;

import net.jxta.discovery.*;
import net.jxta.document.*;
import net.jxta.endpoint.*;
import net.jxta.exception.*;
import net.jxta.id.*;
import net.jxta.impl.peergroup.*;
import net.jxta.peergroup.*;
import net.jxta.pipe.*;
import net.jxta.platform.*;

import net.jxta.protocol.DiscoveryResponseMsg;

/**
 * Responsible for updating Reptile subscriptions with the Proxy mechanism.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: PeerAdvertisementIndexTask.java,v 1.1 2002/03/18 09:26:38 burton Exp $
 */
public class PeerAdvertisementIndexTask extends BaseTask implements Task {

    private PeerGroup peergroup = null;

    private IndexDiscoveryListener idl = new IndexDiscoveryListener();
    
    /**
     * 
     * Create a new <code>PeerAdvertisementIndexTask</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public PeerAdvertisementIndexTask( PeerGroup peergroup ) {

        this.peergroup = peergroup;
        this.setIdentifier( "urn:reptile/task/" + getClass().getName() );

    }
    
    /**
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void run() {

        //discover new peers...

        System.out.println( " FIXME: (debug): trying to discover new peers" );
        
        peergroup.getDiscoveryService().getRemoteAdvertisements( null,
                                                                 DiscoveryService.ADV,
                                                                 "Name",
                                                                 ReptilePeerAdvertisement.class.getName(),
                                                                 100,
                                                                 idl );
        
    }
    
}

/**
 * Discover new messages and add them to the DB.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 */
class IndexDiscoveryListener implements DiscoveryListener {

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void discoveryEvent(DiscoveryEvent e) {

        System.out.println( " FIXME: (debug): FOUND DISCOVERY EVENT: " + e.toString() );
        
        DiscoveryResponseMsg res = e.getResponse();

        // let's get the responding peer's advertisement
        String aRes = res.getPeerAdv();

        Advertisement adv = null;        
        
        try {

            InputStream is = new ByteArrayInputStream( (aRes).getBytes() );

            adv = AdvertisementFactory.newAdvertisement( new MimeMediaType( "text/xml" ), is);

            //FIXME: add this to the DB if it isn't there already.
            
        } catch ( Throwable t ) {
            return;
        }

        //ok... if this is a ReptilePeerAdvertisement add it to the DB (assuming
        //we don't already have it.)

        if ( ReptilePeerAdvertisement.isReptilePeerAdvertisement( adv ) ) {

            ReptilePeerAdvertisement rpa = (ReptilePeerAdvertisement)adv;

            //see if the adv is already in the DB.

            try { 

                //get this module by peer Id...
                PeerAdvertisement padv = PeerAdvertisementPeer.
                    getPeerAdvertisementByPeerID( rpa.getPeerID() );
                
                //if it is null... try to save it ot the DB.
                if ( padv == null ) {

                    padv = new PeerAdvertisement();

                    update( padv, rpa );
                     
                } else if ( padv.getLocalExpirationTime() < rpa.getLocalExpirationTime() ) {

                    //if we already have a advertisement from this peer... just
                    //update its metainfo.... we need to do this by expiration time.

                    update( padv, rpa );
                    
                } 

            } catch ( Throwable t ) {
                
                t.printStackTrace();
                
            }
            
        } 

    }

    /**
     * Update the PeerAdvertisement in the db.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void update( PeerAdvertisement padv, ReptilePeerAdvertisement rpa ) throws Exception {

        padv.setAdvertisementID( rpa.getID().toString() );
        padv.setName( rpa.getPeerName() );
        padv.setType( "urn:jxta" );
        padv.setPeerID( rpa.getPeerID() );
        padv.setTitle( rpa.getTitle() );
        padv.setDescription( rpa.getDescription() );
        padv.setImage( rpa.getImage() );
        padv.setLocalExpirationTime( rpa.getLocalExpirationTime() );

        padv.save();

    }
            
}
