/*
 * ---- 
 *
 * $Id: ReptilePeerAdvertisement.java,v 1.6 2002/05/14 05:01:12 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package org.openprivacy.reptile.jxta.protocol;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.services.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import net.jxta.discovery.*;
import net.jxta.document.*;
import net.jxta.endpoint.*;
import net.jxta.exception.*;
import net.jxta.id.*;
import net.jxta.impl.peergroup.*;
import net.jxta.impl.protocol.*;
import net.jxta.peergroup.*;
import net.jxta.pipe.*;
import net.jxta.platform.*;
import net.jxta.protocol.*;

import net.jxta.impl.document.LiteXMLDocument;

import net.jxta.impl.document.*;

public class ReptilePeerAdvertisement extends ModuleSpecAdv {

    /**
     * Default expiration time of 2 hours. This should allow peers to come in
     * and out without too many stale entries.
     */
    public static final long EXPIRATION = 1000 * 60 * 60 * 2;
    
    /**
     * 
     * Create a new <code>ReptilePeerAdvertisement</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public ReptilePeerAdvertisement( PeerGroup platform ) throws Exception {

        //add a Parm element and include misc Reptile info.

        //WARNING: there are some nasty class casting here!
        StructuredTextDocument param = (StructuredTextDocument)StructuredDocumentFactory
            .newStructuredDocument( new MimeMediaType( "text/xml" ), "Parm" );

        LiteXMLDocument pdoc = (LiteXMLDocument)param;

        pdoc.appendChild( param.createElement( "peer-id", platform.getPeerID().toString() ) );
        pdoc.appendChild( param.createElement( "peer-name", platform.getPeerName() ) );
        pdoc.appendChild( param.createElement( "advertisement-type", getClass().getName() ) );

        String title = SettingPeer.getSetting( " reptile.settings.peer.jxta.title" ).getValue();
        String description = SettingPeer.getSetting( " reptile.settings.peer.jxta.description" ).getValue();
        String image = SettingPeer.getSetting( "reptile.setting.weblog.image.URL" ).getValue();
        
        pdoc.appendChild( param.createElement( "title", title ) );
        pdoc.appendChild( param.createElement( "description", description ) );
        pdoc.appendChild( param.createElement( "image", image ) );

        this.setParam( param );

        this.setName( ReptilePeerAdvertisement.class.getName() );
        this.setVersion( "1.0.0" );
        this.setCreator( "http://reptile.openprivacy.org" );
        this.setModuleSpecID( IDFactory.newModuleSpecID( IDFactory.newModuleClassID() ) );
        this.setSpecURI( "http://reptile.openprivacy.org" );

    }

    /**
     * Get the title for this adv
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getTitle() {

        return getTag( this, "title" );
        
    }
    
    /**
     * Get the title for this adv
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getDescription() {

        return getTag( this, "description" );
        
    }

    /**
     * Get the PeerID for this adv
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getPeerID() {

        return getTag( this, "peer-id" );
        
    }

    /**
     * Get the PeerID for this adv
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getPeerName() {

        return getTag( this, "peer-name" );
        
    }

    /**
     * Get the image for this adv
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getImage() {

        return getTag( this, "image" );
        
    }

    /**
     * Return true if this is a ReptilePeerAdvertisement.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static boolean isReptilePeerAdvertisement( Advertisement adv ) {

        if ( adv instanceof ModuleSpecAdvertisement ) {

            ModuleSpecAdvertisement msa = (ModuleSpecAdvertisement)adv;            

            String at = getTag( msa, "advertisement-type" );

            return ( at != null && at.equals( ReptilePeerAdvertisement.class.getName() ) );

        } 

        return false;
        
    }

    /**
     * Get a tag from this MSA or null if not found...
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private static String getTag( ModuleSpecAdvertisement msa, String tag ) {

        StructuredDocument sd = msa.getParam();

        if ( sd == null )
            return null;
        
        Enumeration penum = ((LiteXMLDocument)sd).getChildren( tag );
        
        if ( penum.hasMoreElements() ) {

            String value = ((LiteXMLElement)penum.nextElement() ).getTextValue();

            return value;
        }

        return null;

    }

}
