/*
 * ---- 
 *
 * $Id: JXTAInitializer.java,v 1.14 2002/09/15 07:55:01 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package org.openprivacy.reptile.jxta.init;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.init.*;
import org.openprivacy.reptile.jxta.protocol.*;
import org.openprivacy.reptile.jxta.tasks.*;
import org.openprivacy.reptile.services.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import net.jxta.discovery.*;
import net.jxta.document.*;
import net.jxta.endpoint.*;
import net.jxta.exception.*;
import net.jxta.id.*;
import net.jxta.impl.peergroup.*;
import net.jxta.peergroup.*;
import net.jxta.pipe.*;
import net.jxta.platform.*;
import net.jxta.protocol.*;

import net.jxta.impl.shell.bin.Shell.Shell;

import org.jxta.bridge.*;
import org.jxta.bridge.bootstrap.*;
import org.jxta.bridge.jxta.*;

import talon.*;
import talon.util.*;

public class JXTAInitializer {

    /**
     * 
     * Create a new <code>JXTAInitializer</code> instance.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public JXTAInitializer() { }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public void init() throws Exception {

        //only if necessary

        if ( SystemProperties.getBoolean( SystemProperties.REPTILE_JXTA_ENABLED_KEY ) ) {
            
            System.out.println( "Starting JXTA services..." );

            //bootstrap JXTA and AXIS...
            PeerGroupFactory.setPlatformClass( net.jxta.impl.peergroup.Platform.class );
            PeerGroupFactory.setStdPeerGroupClass( net.jxta.impl.peergroup.StdPeerGroup.class );
        
            PeerGroup platform = PeerGroupFactory.newPlatform();

            PeerGroup netPeerGroup = PeerGroupFactory.newNetPeerGroup( platform );
            
            SOAPService service = new SOAPService();
        
            ServiceDescriptor descriptor = ReptileSearchService.DESCRIPTOR;

            //FIXME: this needs to be added back in!!!
            //service.init( platform, netPeerGroup, descriptor );

            Thread thread = new ServiceThread( service );
            thread.start(); //start accepting SOAP requests

            //create a new peer advertisement on this peergroup

            PeerGroup group = service.getRunData().getPeerGroup();
            DiscoveryService ds = group.getDiscoveryService();

            ReptilePeerAdvertisement rpa = new ReptilePeerAdvertisement( platform );
                        
            ds.publish( rpa, DiscoveryService.ADV,
                        ReptilePeerAdvertisement.EXPIRATION, ReptilePeerAdvertisement.EXPIRATION );

            ds.remotePublish( rpa, DiscoveryService.ADV, ReptilePeerAdvertisement.EXPIRATION ); 
            
            //and discover other peers.

            PeerAdvertisementIndexTask task = new PeerAdvertisementIndexTask( group ) ;

            //run this right off the bat...
            TaskManager.runTask( task );
            
            TaskManager.getInstance().register( task );

            this.initShell( netPeerGroup );
            
            System.out.println( "Starting JXTA services...done" );

        } 
        
    }

    /**
     * Init the JXTA Shell if necessary.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void initShell( PeerGroup netPeerGroup ) throws Exception {

        //startup a JXTA Shell if necessary.
        if ( SystemProperties.getBoolean( SystemProperties.REPTILE_JXTA_STARTUP_SHELL_KEY ) ) {

            System.out.println( "Starting JXTA shell..." );

            Shell shell = new Shell( true );

            shell.init( netPeerGroup,
                        netPeerGroup.getPeerGroupID(),
                        netPeerGroup.getPeerGroupAdvertisement() );
                
            shell.startApp( new String[] {} );
                
            System.out.println( "Starting JXTA shell...done" );

        }
        
    }
    
    /**
     * Startup JXTA/Reptile from the command line.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public static void main( String[] args ) {

        try { 
            
            new JXTAInitializer().init();
            
        } catch ( Throwable t ) {
            
            t.printStackTrace();
            
        }
        
    }
    
}
