/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.init;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.feeds.init.*;

import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.factories.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: SystemPropertyInitializer.java,v 1.5 2002/07/06 05:57:56 burton Exp $
 */
public class SystemPropertyInitializer {
    
    private ServletConfig config;

    /**
     * 
     * Create a new <code>SystemPropertyInitializer</code> instance.
     *
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SystemPropertyInitializer.java,v 1.5 2002/07/06 05:57:56 burton Exp $
     */
    public SystemPropertyInitializer( ServletConfig config ) {
        
        this.config = config;

    }
    
    /**
     * Describe <code>init</code> method here.
     *
     * @exception ReptileException if an error occurs
     */
    public void init() throws Exception {

        //dump VM System info...
        System.out.println( "Virtual Machine information: " );
        System.out.println( "------" );
        dump( "java.runtime.name" );
        dump( "java.runtime.version" );
        dump( "java.specification.vendor" );
        dump( "java.vm.info" );
        dump( "java.vm.name" );
        System.out.println( "------" );

        System.out.println( "Loading system properties..." );
        System.out.println( "------" );
        
        Properties props = new Properties();

        props.load( config.getServletContext().getResourceAsStream( "/WEB-INF/etc/system.properties" ) );

        //go through the properties and merge them into the system properties.

        Enumeration enum = props.keys();

        while ( enum.hasMoreElements() ) {

            String key = (String)enum.nextElement();

            //if this key does not exist in the system properties... add it.

            if ( System.getProperty( key ) == null ) {

                System.getProperties().put( key, props.get( key ) );

                dump( key );
                
            } 
            
        } 
        
        System.out.println( "------" );
        System.out.println( "Loading system properties...done" );
        
    }

    /**
     * Dump a system property.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void dump( String name ) {
        
        System.out.println( name + " == " + System.getProperty( name ) );
        
    }
    
}
