/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.init;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.feeds.init.*;
import org.openprivacy.reptile.jxta.init.*;

import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.factories.*;

/**
 * Initializes reptile by trying to update all necessary content and resources.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ServletInitializer.java,v 1.21 2002/03/26 09:05:04 burton Exp $
 */
public class ServletInitializer {
    
    private ServletConfig config;

    /**
     * 
     * Create a new <code>ServletInitializer</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ServletInitializer.java,v 1.21 2002/03/26 09:05:04 burton Exp $
     */
    public ServletInitializer( ServletConfig config ) {
        
        this.config = config;
        
    }
    
    /**
     * Describe <code>init</code> method here.
     *
     * @exception ReptileException if an error occurs
     */
    public void init() throws ReptileException {

        try { 

            //initialize system properties

            System.out.println( " FIXME: ( debug ): 1 init of SystemPropertyInitializer" );
            new SystemPropertyInitializer( config ).init();
            System.out.println( " FIXME: ( debug ): 2 END init of SystemPropertyInitializer" );
            
            new GeneralInitializer().init();
            
            //perform any necesary initialization
            
            ResourceMapper mapper = new ServletContextResourceMapper( config.getServletContext() );

            //Tell Talon how to load Resources...
            TalonResources.getInstance().setResourceMapper( mapper );
            
            Log.debug( "Using resource mapper: " + mapper.getClass().getName() );

            //get a proxy to use as a resource mappers
            Proxy proxy = ProxyFactory.getInstance( mapper );
            
            ReptileResources.getInstance().setProxy( proxy );
            
            //continually update subscriptions...

            TaskManager.getInstance().register( SubscriptionProxyUpdateTask.class );
            
            //turbine needs to be initialized before the content feeds
            new TurbineInitializer().init();

            boolean feedsDisabled = SystemProperties.getBoolean( SystemProperties.REPTILE_SYSTEM_FEEDS_DISABLED_KEY );
            
            if ( ! feedsDisabled ) {
                new FeedsInitializer().init();
            } else {
                Log.debug( "Feeds system disabled." );
            }

            //JXTA init...
            new JXTAInitializer().init();

            //now initialize the tasks system.  Make sure to initialize these
            //last... should be dependant on the other initialization.
            new TaskInitializer().init();
            
        } catch ( Throwable t ) {

            Log.error( t );
            throw new ReptileException( t );

        }
        
    }
    
}
