/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.init;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.factories.*;

/**
 * Initializes Reptile in an offline manner.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: OfflineInitializer.java,v 1.7 2001/11/25 09:01:25 burton Exp $
 */
public class OfflineInitializer {
    
    private String resourceDirectory;

    /**
     * Creates a new <code>OfflineInitializer</code> instance.
     *
     * @param resourceDirectory a <code>String</code> value describing the base
     * directory for resources
     * 
     */
    public OfflineInitializer( String resourceDirectory ) {
        
        this.resourceDirectory = resourceDirectory;

    }

    /**
     * Init the Offline Initializer.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: OfflineInitializer.java,v 1.7 2001/11/25 09:01:25 burton Exp $
     */
    public void init() throws ReptileException {

        new GeneralInitializer().init();

        ResourceMapper mapper = new DirectoryResourceMapper( resourceDirectory );

            //Tell Talon how to load Resources...
        TalonResources.getInstance().setResourceMapper( mapper );

        Proxy proxy = null;
        
        try { 
            
            proxy = ProxyFactory.getInstance( mapper );
            
        } catch ( Throwable t ) {

            throw new ReptileException( t );
            
        }
            
        ReptileResources.getInstance().setProxy( proxy );

        new TurbineInitializer().init();

    }
    
}
