/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.init;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Initializes Reptile in an offline manner.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: GeneralInitializer.java,v 1.11 2002/03/26 08:48:12 burton Exp $
 */
public class GeneralInitializer {

    /**
     * Creates a new <code>GeneralInitializer</code> instance.
     *
     */
    public GeneralInitializer() { }

    public void init() throws ReptileException {
        
        //Use Apache XSLTC for the Transformer....

        String key = ReptileResources.JAVAX_XML_TRANSFORM_TRANSFORMERFACTORY;

        //Xalan 2.1
        //String value = "org.apache.xalan.xsltc.runtime.TransformerFactoryImpl";

        //Xalan 2.2
        String value = "org.apache.xalan.xsltc.trax.TransformerFactoryImpl";

        //FIXME: XSLTC doesn't support extensions.  We can't use it right now.
        //System.setProperty( key, value );

        //make the sytem temp directory...  This is used by hypersonic, logging, etc.

        new File( System.getProperty( SystemProperties.JAVA_IO_TMPDIR_KEY )
                  + "/reptile/logs").mkdirs();

    }
    
}
