/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.feeds.xml;

import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.openprivacy.panther.components.*;

import talon.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.feeds.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

/**
 * Handles parsing out content feeds and starting them up.
 * 
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ContentFeedsHandler.java,v 1.3 2002/02/22 01:13:07 burton Exp $
 */
public class ContentFeedsHandler extends DefaultHandler {

    public static final URI RESOURCE = new URI( "resource:/xml/content/feeds/content-feeds.xml" );

    private String location = "";

    private String contentType = "";
    
    private String updatePeriod = "";

    private String updateFrequency = "";

    private String local = "";
    
    /**
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeedsHandler.java,v 1.3 2002/02/22 01:13:07 burton Exp $
     */
    public ContentFeedsHandler() throws ReptileException {

        try {

            Proxy proxy = ReptileResources.getInstance().getProxy();

            XMLReader xmlr = ReptileParserFactory.getXMLReader();

            xmlr.setContentHandler( this );
            
            InputSource is = new InputSource( proxy.get( RESOURCE ).getInputStream() );

            xmlr.parse( is );

        } catch ( Throwable t ) {

            Log.error( t );
            
            throw new ReptileException( t );
            
        } 
        
    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeedsHandler.java,v 1.3 2002/02/22 01:13:07 burton Exp $
     */
    public void startElement( String ns_uri,
                              String local,
                              String raw,
                              Attributes attrs ) {

        this.local = local;
        
        if ( ns_uri.equals( ReptileResources.CONTENT_FEEDS_NAMESPACE ) &&
             local.equals( "feed" ) ) {

            location = attrs.getValue( "location" );
            contentType = attrs.getValue( "contentType" );
            
        } 
        
    } 

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeedsHandler.java,v 1.3 2002/02/22 01:13:07 burton Exp $
     */
    public void endElement( String ns_uri,
                            String local,
                            String qName) {

        this.local = "";
        
        if ( ns_uri.equals( ReptileResources.CONTENT_FEEDS_NAMESPACE ) &&
             local.equals( "feed" ) ) {
            
            //should be the point where we have all the information about this
            //feed we need.
            
            //compute the differece based on the update period and frequency

            int frequency = Integer.parseInt( updateFrequency );

            long interval = 0;
            
            if ( updatePeriod.equals( "daily" ) )
                interval = 24 * 60 * 60 * 1000 * frequency;
            else if ( updatePeriod.equals( "hourly" ) )
                interval = 60 * 60 * 1000 * frequency;
            else
                throw new RuntimeException( "Invalid updatePeriod -> " + updatePeriod );

            // OK.  We have calculated a new interval, have the location, etc.
            // Time to start a new task.

            Log.debug( "Found content feed: " + location );
            
            Task task = new FeedUpdateTask( location, contentType );

            task.setType( Task.TYPE_OCS );
            
            task.setInterval( interval );
            
            try {

                //now start the task.
                
                TaskManager.getInstance().register( task );

                Proxy proxy = ReptileResources.getInstance().getProxy();

                //enforce the minCachedInterval
                if ( proxy.contains( location ) ) {

                    ProxyEntry entry = proxy.get( location );

                    entry.setMinCachedInterval( interval );

                    entry.save();
                    
                } 
                
            } catch ( Throwable t ) {

                Log.error( t );

            }
            
        }
            
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentFeedsHandler.java,v 1.3 2002/02/22 01:13:07 burton Exp $
     */
    public void characters( char[] ch,
                            int start,
                            int length ) {

        if ( local.equals( "updateFrequency" ) ) 
            this.updateFrequency = new String( ch, start, length );

        if ( local.equals( "updatePeriod" ) ) 
            this.updatePeriod = new String( ch, start, length );
        
    }
    
}
