/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.feeds.tasks;

import java.io.*;
import java.util.*;

import org.openprivacy.panther.event.*;
import org.openprivacy.panther.components.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.feeds.xml.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

/**
 * Responsible for updating content with the Proxy, performing any necessary
 * update tasks (DB, whatever) and possibly reparsing their content.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: FeedUpdateTask.java,v 1.9 2002/03/23 22:31:33 burton Exp $
 */
public class FeedUpdateTask extends BaseTask implements Task {
    
    /**
     * Holds the location this task is required to update.
     */
    private String location;

    private String contentType;

    private Proxy proxy = ReptileResources.getInstance().getProxy();
    
    /**
     * 
     * Create a new <code>FeedUpdateTask</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public FeedUpdateTask( String location,
                           String contentType ) {

        this.location = location;
        this.contentType = contentType;
        
        this.setIdentifier( location );

        //pay attention to proxy updates

    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void run() throws Exception {

        if ( this.requireNotStale( location ) ) {
            return;
        } 
            
        URI uri = new URI( location );

        //tell the Proxy to update this URL
        ProxyEntry entry = proxy.getAndWait( uri );
            
        update( entry );
                
        setLastMessage( MESSAGE_SUCCESSFUL );
        
    }

    /**
     * Update this content.
     * 
     * @see ProxyEventListener
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     */
    public void update( ProxyEntry entry ) {

        String proxiedLocation = entry.getIdentifier().toString();

        //was this the ProxyEntry feed we wanted to update?
        if ( proxiedLocation.equals( this.location ) &&
             OCSContentFeedsHandler.isOCSNamespace( contentType ) ) {
            
            try { 
                
                new OCSContentFeedsHandler( location );
                
            } catch ( Throwable t ) {
 
                Log.error( this, t );

                this.setLastMessage( t.getMessage() );
                
            }
            
        } 

    }
    
}

