/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.feeds.init;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.reptile.actions.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.feeds.xml.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Responible for starting up all Tasks necesary for updating content feeds.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: FeedsInitializer.java,v 1.1 2001/11/27 03:03:56 burton Exp $
 */
public class FeedsInitializer {

    /**
     * Creates a new <code>GeneralInitializer</code> instance.
     *
     */
    public FeedsInitializer() { }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: FeedsInitializer.java,v 1.1 2001/11/27 03:03:56 burton Exp $
     */
    public void init() throws ReptileException {

        Log.message( "Initializing FeedsInitializer..." );
        
        //parse out the content-feeds.xml file and start the necessary tasks.
        new ContentFeedsHandler();

        Log.message( "Initializing FeedsInitializer...done" );        

    }
    
}
