/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions.om;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.net.*;

import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.extensions.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;

import talon.util.*;

import org.jdom.*;
import org.jdom.output.*;

import org.apache.xpath.objects.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SubscriptionLayoutExtension.java,v 1.1 2002/02/25 08:17:20 burton Exp $
 */
public class SubscriptionLayoutExtension {

    /**
     * Get the layers from the categories
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String layers() throws Exception {
        
        Namespace layoutns = Namespace.getNamespace( "layout", ReptileResources.LAYOUT_NAMESPACE );

        Channel[] subs = ChannelPeer.getSubscriptions();

        //FIXME: don't allow duplicate categories.

        StringBuffer buff = new StringBuffer();

        XMLOutputter xo = new XMLOutputter();

        Vector found = new Vector();
        
        for ( int i = 0; i < subs.length; ++i ) {

            Channel current = subs[i];

            String name = current.getCategory().getName();

            if ( found.contains( name ) == false ) {
                
                Element layer = new Element( "layer", layoutns );

                layer.setAttribute( "numColumns", Integer.toString( 2 ) );
                layer.setAttribute( "name", name );

                //nnow add this to the nodelist.

                buff.append( xo.outputString( layer ) );

                buff.append( "\n" );

                found.add( name );
                
            } 
            
        } 

        return buff.toString();

    }

    /**
     * Get the layers from the categories
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String subscriptions() throws Exception {
        
        Namespace layoutns = Namespace.getNamespace( "layout", ReptileResources.LAYOUT_NAMESPACE );

        StringBuffer buff = new StringBuffer();

        XMLOutputter xo = new XMLOutputter();

        Category[] categories = CategoryPeer.getCategories();

        for ( int i = 0; i < categories.length; ++i ) {

            Category current_cat = categories[i];

            //get subscriptions within this category...

            Channel[] subs = ChannelPeer.getSubscriptionsByCategory( current_cat );

            //we need to sort these by category...
            for ( int j = 0; j < subs.length; ++j ) {

                Channel current = subs[j];

                Element content = new Element( "content", layoutns );

                content.setAttribute( "contentType", current.getContentType() );
                content.setAttribute( "location", current.getLocation() );
            
                Element position = new Element( "position", layoutns );

                position.setAttribute( "layer", current.getCategory().getName() );

                String column = "right";

                if ( j % 2 == 0 ) {
                
                    column = "left";
                
                } 
    
                position.setAttribute( "column", column );

                content.addContent( position );
            
                buff.append( xo.outputString( content ) );
            
                buff.append( "\n" );

            } 

        } 

        return buff.toString();

    }

}
