/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions.om;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.om.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;

import talon.util.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SettingExtension.java,v 1.3 2002/02/22 09:17:14 burton Exp $
 */
public class SettingExtension {

    /**
     * Test that the given setting (name) == 'true'
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean test( String name ) {

        try { 
            
            return SettingPeer.getSetting( name ).getValue().equals( "true" );
            
        } catch ( Throwable t ) {

            //obviously not.
            t.printStackTrace();

            return false;
            
        }

    }

        
    /**
     * Test that the given setting equals the given value.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean test( String name, String value ) {

        try { 
            
            return SettingPeer.getSetting( name ).getValue().equals( value );
            
        } catch ( Throwable t ) {
            
            //obviously not.
            t.printStackTrace();

            return false;
            
        }

    }
    
    /**
     * @see #value
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String value( String name ) {

        try { 
            
            return SettingPeer.getSetting( name ).getValue();
            
        } catch ( Throwable t ) {
            
            t.printStackTrace();

            return "";
            
        }

    }
    
    /**
     * Get the value of a named property with its name.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SettingExtension.java,v 1.3 2002/02/22 09:17:14 burton Exp $
     */
    public String value( XSLProcessorContext context,
                         ElemExtensionCall elem ) {

        try { 

            //get the of the setting to fetch.
            String name = elem.getAttribute( "name",
                                             context.getContextNode(),
                                             context.getTransformer() );

            return value( name );
            
        } catch ( Throwable t ) {

            Log.error( t );

            return "";
            
        }
        
    }

}
