/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions.om;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.net.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.om.*;

import talon.util.*;

import javax.xml.transform.TransformerException;

import org.jdom.*;
import org.jdom.output.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ChannelSearchExtension.java,v 1.2 2002/01/30 07:19:18 burton Exp $
 */
public class ChannelSearchExtension {

    public static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";

    /**
     * Get the total number of content feeds known by title and description.
     *
     * Example:
     * 
     * <search:byTitle query="Linux"/>
     * 
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelSearchExtension.java,v 1.2 2002/01/30 07:19:18 burton Exp $
     */
    public org.w3c.dom.Node byTitleAndDescription( XSLProcessorContext context,
                                                   ElemExtensionCall elem ) {
        
        try { 
            
            String query = getQuery( context, elem );
            
            return getChannels( ChannelPeer.searchByTitleAndDescription( query ) );
            
        } catch ( Throwable t ) {
            
            Log.error( t );

            return null;
            
        }
            
    }

    /**
     * Get the total number of content feeds known.
     *
     * Example:
     * 
     * <search:byTitle query="Linux"/>
     * 
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelSearchExtension.java,v 1.2 2002/01/30 07:19:18 burton Exp $
     */
    public org.w3c.dom.Node byTitle( XSLProcessorContext context,
                                     ElemExtensionCall elem ) {
        
        try { 
            
            String query = getQuery( context, elem );
            
            return getChannels( ChannelPeer.searchByTitle( query ) );
            
        } catch ( Throwable t ) {
            
            Log.error( t );

            return null;
            
        }
            
    }

    /**
     * Get the total number of content feeds known.
     *
     * Example:
     * 
     * <search:byDescription query="Linux"/>
     * 
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelSearchExtension.java,v 1.2 2002/01/30 07:19:18 burton Exp $
     */
    public org.w3c.dom.Node byDescription( XSLProcessorContext context,
                                           ElemExtensionCall elem ) {
        
        try { 
            
            String query = getQuery( context, elem );
            
            return getChannels( ChannelPeer.searchByDescription( query ) );
            
        } catch ( Throwable t ) {
            
            Log.error( t );

            return null;
            
        }
            
    }

    /**
     * Get the query specified
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelSearchExtension.java,v 1.2 2002/01/30 07:19:18 burton Exp $
     */
    private String getQuery( XSLProcessorContext context,
                             ElemExtensionCall elem ) throws Exception {

        return elem.getAttribute( "query", context.getContextNode(), context.getTransformer() );

    }
    
    /**
     * Convert a list of channels to a NodeSet
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelSearchExtension.java,v 1.2 2002/01/30 07:19:18 burton Exp $
     */
    private org.w3c.dom.Node getChannels( Channel[] channels ) throws Exception {

        Namespace resultsNamespace = Namespace.getNamespace( "results", ReptileResources.SEARCH_NAMESPACE );

        Namespace dcNamespace = Namespace.getNamespace( "dc", DC_NAMESPACE );
        
        Element results = new Element( "results", resultsNamespace );

        TimeStamp timestamp = new TimeStamp();

        results.setAttribute( "total", Integer.toString( ChannelPeer.getCount() ) );

        results.setAttribute( "found", Integer.toString( channels.length ) );
        
        for ( int i = 0; i < channels.length; ++i ) {

            Channel current = channels[ i ];
            
            Element entry = new Element( "entry", resultsNamespace );

            entry.addContent( new Element( "title", dcNamespace ).setText( current.getTitle() ) );

            entry.addContent( new Element( "description", dcNamespace ).setText( current.getDescription() ) );

            Element link = new Element( "link", resultsNamespace );

            link.setAttribute( "location", current.getLocation() );

            link.setAttribute( "contentType", current.getContentType() );

            link.setAttribute( "date-found", timestamp.get( current.getDateFound() ) );
            link.setAttribute( "last-updated", timestamp.get( current.getLastUpdated() ) );

            entry.addContent( link );
            
            results.addContent( entry );
            
        } 
        
        return new DOMOutputter().output( results );
        
    }
    
}
