/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions.om;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.om.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;

import talon.util.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ChannelExtension.java,v 1.10 2002/03/23 21:29:34 burton Exp $
 */
public class ChannelExtension {

    private ContentTransformerMap map = new ContentTransformerMap();
    
    /**
     * Get the total number of content feeds known.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelExtension.java,v 1.10 2002/03/23 21:29:34 burton Exp $
     */
    public int count( XSLProcessorContext context,
                      ElemExtensionCall elem ) {

        try { 
            
            return ChannelPeer.getCount();
            
        } catch ( Throwable t ) {

            Log.error( t );

            return -1;
            
        }
        
    }

    /**
     * @see ContentTransformerMap#isSupportedContentType
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean isSupportedContentType( String contentType ) {

        return map.isSupportedContentType( contentType );

    }

    /**
     * Get the title for the given location
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getTitle( String location ) {

        try {
             
            return ChannelPeer.getChannelByLocation( location ).getTitle();

        } catch ( Exception e ) {

            Log.error( location );
            Log.error( e );
            
            return "UNKNOWN";
            
        } 

    }

    /**
     * Get the title for the given location
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean isSubscription( String location ) {

        try {

            Channel channel = ChannelPeer.getChannelByLocation( location );

            return channel != null && channel.isSubscription();

        } catch ( Exception e ) {

            e.printStackTrace();
            
            return false;
            
        } 

    }

    /**
     * Return true if this is in the CHANNEL table.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean isChannel( String location ) {

        try {

            Channel channel = ChannelPeer.getChannelByLocation( location );

            return channel != null;

        } catch ( Exception e ) {

            //this is normal.
            
            return false;
            
        } 

    }
    
    /**
     * Get the content type for this channel's location
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getContentType( String location ) {

        try {
             
            return ChannelPeer.getChannelByLocation( location ).getContentType();

        } catch ( Exception e ) {

            Log.error( location );
            Log.error( e );
            
            return "UNKNOWN";
            
        } 

    }
    
    /**
     * Get the image (URL) for this channel by it's location.  If none was found
     * return a default.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getImage( String channel ) {

        String default_image = "/reptile/images/channel.png";
        
        try { 
            
            Image image = ImagePeer.getImageByChannel( channel );
            
            if ( image == null || image.getLocation() == null || image.getLocation().equals( "" ) )
                return default_image;
            
            return image.getLocation();
            
        } catch ( Throwable t ) {

            Log.error( t );

            return default_image;
            
        }
        
    }
    
}
