/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions.om;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.net.*;

import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.extensions.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;

import talon.util.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ArticleExtension.java,v 1.6 2002/02/20 22:44:11 burton Exp $
 */
public class ArticleExtension {

    /**
     * Get the total number of content feeds known.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ArticleExtension.java,v 1.6 2002/02/20 22:44:11 burton Exp $
     */
    public int count( XSLProcessorContext context,
                      ElemExtensionCall elem ) {

        try { 
            
            return ArticlePeer.getCount();
            
        } catch ( Throwable t ) {

            Log.error( t );

            return -1;
            
        }
        
    }

    /**
     * Return the date found for the given location
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getDateFound( String location ) {

        String dateFound = null;

        TimeStamp timestamp = new TimeStamp();
        
        try { 
            
            Article article = ArticlePeer.getArticleByLocation( location );

            if ( article == null ) {
                Log.error( "Couldn't get date found for location: " + location );
            } else {
                dateFound = timestamp.get( article.getDateFound() );
            }

        } catch ( Throwable t ) {
            Log.error( t );
        }

        if ( dateFound == null )
            dateFound = timestamp.get( System.currentTimeMillis() );

        return dateFound;
        
    }

    /**
     * Get the title for the given location
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getTitle( String location ) {

        try {
             
            return ArticlePeer.getArticleByLocation( location ).getTitle();

        } catch ( Exception e ) {

            Log.error( location );
            Log.error( e );
            
            return "UNKNOWN";
            
        } 

    }

    /**
     * Get the title for the given location
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getDescription( String location ) {

        try {
             
            return ArticlePeer.getArticleByLocation( location ).getDescription();

        } catch ( Exception e ) {

            Log.error( location );
            Log.error( e );
            
            return "UNKNOWN";
            
        } 

    }
    

    
}
