/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions.content;

import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.xerces.dom.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.xml.serializers.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.jdom.*;
import org.jdom.output.*;

import talon.util.*;

/**
 * Xalan extension which can give us feedback on what tasks are currently
 * running and what their last state was.
 * 
 * <tasks>
 * 
 * <task identifier="" classname="" lastRan="">
 * 
 * <!-- running or waiting -->
 * <state></state>
 *
 * <!-- string describing the status of this task -->
 * <status></status>
 * 
 * </task>
 * 
 * </tasks>
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: TasksExtension.java,v 1.9 2002/02/06 21:48:15 burton Exp $
 */
public class TasksExtension {

    /**
     * Get the current Thread information WRT the current JVM.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: TasksExtension.java,v 1.9 2002/02/06 21:48:15 burton Exp $
     */
    public String getContent() {

        Namespace namespace = Namespace.getNamespace( "tasks",
                                                      ReptileResources.TASKS_NAMESPACE );

        Element root = new Element( "tasks", namespace );

        Enumeration tasks = TaskManager.getInstance().getTasks();
        
        //now go through all the tasks.

        while ( tasks.hasMoreElements() ) {

            Task task = (Task)tasks.nextElement();
            
            root.addContent( new Element( "task", namespace )
                .setAttribute( "identifier", task.getIdentifier() )
                .setAttribute( "lastRan", Long.toString( task.getLastRan() ) )
                .setAttribute( "interval", Long.toString( task.getInterval() ) )
                .setAttribute( "classname", task.getClass().getName() )
                .setAttribute( "state", task.getState() )
                .setAttribute( "type", task.getType() )
                .setAttribute( "lastMessage", task.getLastMessage() ) );
            
        }
        
        try { 

            XMLOutputter outputter = new XMLOutputter();

            outputter.setEncoding( ReptileResources.DEFAULT_XML_ENCODING );

            return outputter.outputString( root );
            
        } catch ( Throwable t ) {

            //FIXME: it would be nice to return error markup here.
            
            Log.error( t );

            return new ErrorXMLSerializer( t ).serializeAsString();
            
        }
        
    }

}
