/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import org.jdom.*;
import org.jdom.output.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

/**
 * 
 *  Provides metainfo about the current Xalan install.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Xalan.java,v 1.2 2001/12/02 06:16:40 burton Exp $
 */
public class Xalan {

    /**
     * Get the classloader used by Xalan.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Xalan.java,v 1.2 2001/12/02 06:16:40 burton Exp $
     */
    public String classloader( XSLProcessorContext context,
                               ElemExtensionCall elem ) {

        String classloader = this.getClass().getClassLoader().getClass().getName();

        return classloader;

    }

    /**
     * Get the given feature from Xalan.  
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Xalan.java,v 1.2 2001/12/02 06:16:40 burton Exp $
     */
    public String getURIResolver( XSLProcessorContext context,
                                  ElemExtensionCall elem ) {

        return context.getTransformer().getURIResolver().getClass().getName();
        
    }

    /**
     * Get the current Reptile transformer factory
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Xalan.java,v 1.2 2001/12/02 06:16:40 burton Exp $
     */
    public String getTransformerFactory( XSLProcessorContext context,
                                         ElemExtensionCall elem ) {

        return System.getProperty( ReptileResources.JAVAX_XML_TRANSFORM_TRANSFORMERFACTORY );
        
    }

    /**
     * Get the current Reptile transformer factory
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Xalan.java,v 1.2 2001/12/02 06:16:40 burton Exp $
     */
    public String getTransformerFactoryImplementation( XSLProcessorContext context,
                                                       ElemExtensionCall elem ) {

        return ReptileTransformerFactory.getInstance().getTransformerFactoryImplementation();
        
    }

}

