/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */


package org.openprivacy.reptile.extensions;


import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import talon.util.*;

/**
 * Extension which handles if a given RSS item is valid.  If it is invalid then
 * an RSS stylesheet should not use it.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ValidItem.java,v 1.6 2001/08/22 17:51:32 burton Exp $
 */
public class ValidItem {
    
    private String link;

    private Vector knownTitles = new Vector(); 
    
    /**
     * Return true (valid) if the item is:
     *
     * <li> Not null
     *
     * <li>Has a length > 0
     * 
     * <li>Hasnn't been shown before.
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ValidItem.java,v 1.6 2001/08/22 17:51:32 burton Exp $
     */
    public boolean isValid( String link, String title ) {

        if ( link == null || title == null )
            Log.warn( "Cant determine validity for null items." );
        
        if ( title == null || title.equals( "" ) ||
             link == null || link.equals( "" ) ) 
            return false;

        ValidItemHandle handle = new ValidItemHandle( link, title );
        
        if ( knownTitles.contains( handle ) )
            return false;

        knownTitles.addElement( handle );

        return true;
        
    }
    
}

class ValidItemHandle {

    String link;

    String title;
    
    /**
     * 
     * Create a new <code>ValidItemHandle</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ValidItem.java,v 1.6 2001/08/22 17:51:32 burton Exp $
     */
    public ValidItemHandle( String link, String title ) {

        this.link = link;
        this.title = title;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ValidItem.java,v 1.6 2001/08/22 17:51:32 burton Exp $
     */
    public boolean equals( Object obj ) {

        if ( this.getClass() == obj.getClass() ) {

            ValidItemHandle handle = (ValidItemHandle)obj;

            return handle.link.equals( this.link ) &&
                   handle.title.equals( this.title );
            
        } 

        return false;

    }

}
