/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import talon.*;
import talon.util.*;

/**
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: TimeStamp.java,v 1.9 2002/02/08 02:55:24 burton Exp $
 */
public class TimeStamp {

    /**
     * Get a timestamp.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: TimeStamp.java,v 1.9 2002/02/08 02:55:24 burton Exp $
     */
    public String get( XSLProcessorContext context,
                       ElemExtensionCall elem ) {

        return get();

    }
    
    /**
     * @see #get(long)
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: TimeStamp.java,v 1.9 2002/02/08 02:55:24 burton Exp $
     */
    public String get() {

        return get( System.currentTimeMillis() );
        
    }

    /**
     * @see #get(long)
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: TimeStamp.java,v 1.9 2002/02/08 02:55:24 burton Exp $
     */
    public String get( String longDate ) {

        return get( Long.parseLong( longDate ) );

    }

    /**
     * Get a timestamp via a string representing the date which should represent
     * the number of milliseconds to display.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: TimeStamp.java,v 1.9 2002/02/08 02:55:24 burton Exp $
     */
    public String get( long date ) {

        return DateFormat.getDateTimeInstance( DateFormat.FULL,
                                               DateFormat.FULL  ).format( new Date( date ) );
        
    }
    
    /**
     * Render an interval as a timestamp.
     * 
     * Result will be in the form of
     * 
     * 4 minute(s), and 48 second(s) 
     *
     * Example:
     *
     * <timestamp:interval difference="60000"/>
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: TimeStamp.java,v 1.9 2002/02/08 02:55:24 burton Exp $
     */
    public String interval( XSLProcessorContext context,
                            ElemExtensionCall elem ) {

        try { 
            
            //allow XPATH... 
            String s_difference = elem.getAttribute( "difference",
                                                     context.getContextNode(),
                                                     context.getTransformer() );
            
            Assert.assert( s_difference, "Difference attribute not specfied." );
            
            return ProxyFunctions.getDateFormated( Long.valueOf( s_difference ).longValue() );
            
        } catch ( Throwable t ) {
            
            Log.error( t );

            return t.getMessage();
            
        }
        
    }

    /**
     * Return the amount of time since the given interval.
     *
     * Result will be in the form of
     * 
     * 4 minute(s), and 48 second(s) 
     *
     * Example:
     *
     * <timestamp:time_since time="1013135890"/>
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String time_since( XSLProcessorContext context,
                              ElemExtensionCall elem ) {

        try { 
            
            //allow XPATH... 
            String s_time = elem.getAttribute( "time",
                                               context.getContextNode(),
                                               context.getTransformer() );
            
            Assert.assert( s_time, "Difference attribute not specfied." );

            long difference = System.currentTimeMillis() - Long.valueOf( s_time ).longValue();

            return ProxyFunctions.getDateFormated( difference );
            
        } catch ( Throwable t ) {
            
            Log.error( t );

            return t.getMessage();
            
        }

    }

}
