/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import org.jdom.*;
import org.jdom.output.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;

import talon.util.*;

/**
 * 
 *  Handles parsing out JMV properties and providing them as an extension.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: SystemPropertiesExtension.java,v 1.1 2002/07/04 20:35:04 burton Exp $
 */
public class SystemPropertiesExtension {

    public static final String RENDEZVOUS_MODE = "rendezvous";
    
    /**
     * Return the value of the given system property.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getProperty( String key ) {

        return System.getProperty( key );

    }
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SystemPropertiesExtension.java,v 1.1 2002/07/04 20:35:04 burton Exp $
     */
    public org.w3c.dom.NodeList properties( XSLProcessorContext context,
                                            ElemExtensionCall elem ) {

        Namespace namespace = Namespace.getNamespace( "jp", ReptileResources.JAVA_PROPERTIES_NAMESPACE );
        
        Element props = new Element( "properties", namespace );

        //get properties as an enumeration

        Properties properties = System.getProperties();

        //remove properties which are too long
        properties.remove( "java.class.path" );
        properties.remove( "sun.boot.class.path" );
        properties.remove( "java.library.path" );

        //can use properties.keySet() to get the keys as a set...
        
        Vector v = new Vector( properties.keySet() );

        //sort the keys so that we can manage them better.
        Collections.sort( v );
        
        Enumeration keys = v.elements();

        String name = null;

        String value = null;
        
        while ( keys.hasMoreElements() ) {

            name = (String)keys.nextElement();

            value = System.getProperty( name );

            props.addContent( new Element( "entry", namespace ).setAttribute( "name", name )
                                                               .setAttribute( "value", value ) );
                
        } 

        try { 

            return new DOMOutputter().output( props ).getChildNodes();
            
        } catch ( Throwable t ) {

            Log.error( t );

            return null;            
            
        }

    }

    /**
     * Return true of this node is operating in rendezvous mode.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public boolean isRendezvous() {

        String mode = SystemProperties.getString( SystemProperties.REPTILE_OPERATION_MODE_KEY );
        
        return mode.equals( RENDEZVOUS_MODE );
        
    }
    
}

