/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.search.requests.*;
import org.openprivacy.reptile.xml.serializers.*;

import org.openprivacy.panther.components.*;

import org.jdom.*;
import org.jdom.output.*;

import org.apache.regexp.*;

/**
 * Provides misc tools for escaping content.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: SearchExtension.java,v 1.6 2002/02/07 01:20:19 burton Exp $
 */
public class SearchExtension {

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public org.w3c.dom.Node serialize( XSLProcessorContext context,
                                       ElemExtensionCall elem ) {
    
        try {
            
            int page = Integer.parseInt( elem.getAttribute( "page",
                                                            context.getContextNode(),
                                                            context.getTransformer() ) );
            
            String handle = elem.getAttribute( "provider-handle",
                                               context.getContextNode(),
                                               context.getTransformer() );

            SearchProvider provider = SearchProviderManager.getInstance().getSearchProvider( handle );

            SearchSerializer serializer = new SearchSerializer( provider );
            
            return serializer.serializeAsNode( page );
            
        } catch ( Throwable t) {
            
            Log.error( t );

            return new ErrorXMLSerializer( t ).serializeAsNode();
            
        }
        
    }

    /**
     * Execute a new search and then serialize the first page.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public org.w3c.dom.Node search( XSLProcessorContext context,
                                    ElemExtensionCall elem ) {

        try {

            String request_name = elem.getAttribute( "request-name",
                                                     context.getContextNode(),
                                                     context.getTransformer() );

            String provider_name = elem.getAttribute( "provider-name",
                                                 context.getContextNode(),
                                                 context.getTransformer() );
            
            SearchProvider provider = SearchProviderManager.getInstance().newProvider( provider_name, request_name );

            SearchSerializer serializer = new SearchSerializer( provider );
            
            return serializer.serializeAsDocument( SearchSerializer.FIRST_PAGE );
            
        } catch ( Throwable t) {

            Log.error( t );

            return new ErrorXMLSerializer( t ).serializeAsNode();

        }

    }

    /**
     * Execute a new search and then serialize the first page.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public org.w3c.dom.Node history( XSLProcessorContext context,
                                     ElemExtensionCall elem ) {

        try {

            String channel = elem.getAttribute( "channel",
                                                context.getContextNode(),
                                                context.getTransformer() );

            SearchRequest request = new ChannelHistorySearchRequest( channel );

            SearchProvider provider = SearchProviderManager.getInstance().newProvider( ArticleSearchProvider.class );

            provider.search( request );

            SearchSerializer serializer = new SearchSerializer( provider );

            return serializer.serializeAsDocument( SearchSerializer.FIRST_PAGE );

        } catch ( Throwable t) {

            Log.error( t );

            return new ErrorXMLSerializer( t ).serializeAsNode();

        }

    }

}
