/*
 * ---- 
 *
 * $Id: ReputationExtension.java,v 1.1 2001/12/12 09:30:50 burton Exp $
 * $Project: http://reptile.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/sierra/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 *
 * ----
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.rce.talon.implementations.util.*;
import org.openprivacy.sierra.reputation.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

/**
 * Responsible for performing reputation stuff.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ReputationExtension.java,v 1.1 2001/12/12 09:30:50 burton Exp $
 */
public class ReputationExtension {

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    public String getReputation( String uri ) {

        try { 

            //get an RCE.
            RCE rce = RCEFactory.getInstance();

            Reputation rep = rce.getReputation( ReferenceFactory.getInstance( uri ) );

            return rep.getPayload( OverallMarkupPayload.IDENTIFIER ).toString();
            
        } catch ( Exception e ) {
            
            Log.error( e );

            //FIXME: don't think we should return null here.
            return XMLEncoder.encode( "Caught java exception: " + e.getMessage() );

        }

    }

}
