/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.util.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;
import org.apache.xalan.transformer.*;

import org.w3c.dom.*;

import javax.xml.transform.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.om.*;

/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: MetaUpdate.java,v 1.7 2002/02/08 06:40:33 burton Exp $
 */
public class MetaUpdate {
    
    /**
     * Create a new  link.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: MetaUpdate.java,v 1.7 2002/02/08 06:40:33 burton Exp $
     */
    public void channel( XSLProcessorContext context,
                         ElemExtensionCall elem ) {

        try { 

            //FIXME: make sure this meets the schema

            Node cn = context.getContextNode();

            TransformerImpl t = context.getTransformer();

            String location = elem.getAttribute( "location", cn, t );

            String site = elem.getAttribute( "site", cn, t );

            String title = elem.getAttribute( "title", cn, t );

            String description = elem.getAttribute( "description", cn, t );

            String contentType = elem.getAttribute( "contentType", cn, t );
            
            ChannelPeer.updateChannel( location, site, contentType, title, description );
            
        } catch ( Throwable t ) {

            Log.error( t );
            
            t.printStackTrace();
            
        }

    }

    /**
     * Update meta info for the given article/item.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public void article( XSLProcessorContext context,
                         ElemExtensionCall elem ) {
        
        try { 

            Node cn = context.getContextNode();

            TransformerImpl t = context.getTransformer();
            
            //FIXME: make sure this meets the schema

            String location = elem.getAttribute( "location", cn, t );

            String title = elem.getAttribute( "title", cn, t );

            String description = elem.getAttribute( "description", cn, t );
            
            String channelLocation = elem.getAttribute( "channel", cn, t );

            ArticlePeer.updateArticle( location, channelLocation, title, description );

        } catch ( Throwable t ) {

            Log.error( t );
            
            t.printStackTrace();
            
        }

    }
    
}
