/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */


package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xml.serializers.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;
import org.w3c.dom.*;

/**
 * Enables us to log via XSLT into the Talon logger.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: LogExtension.java,v 1.2 2001/08/04 10:10:52 burton Exp $
 */
public class LogExtension {

    public void debug(  XSLProcessorContext context,
                        ElemExtensionCall elem ) {

        Log.debug( elem.getAttribute( "value" ) );
        
    }

    public void message(  XSLProcessorContext context,
                          ElemExtensionCall elem ) {

        Log.message( elem.getAttribute( "value" ) );
        
    }

    public void warn(  XSLProcessorContext context,
                       ElemExtensionCall elem ) {

        Log.warn( elem.getAttribute( "value" ) );
        
    }

    public void error(  XSLProcessorContext context,
                        ElemExtensionCall elem ) {

        Log.error( elem.getAttribute( "value" ) );
        
    }
    
}
