/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.util.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.util.*;

import javax.xml.transform.TransformerException;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 * Builds URLs using from params and values.  This take the compexity away from
 * building complex URLs with HTTP params.  This can work as a Xalan extension
 * or right from the Servlet API.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
 */
public class LinkProducer {
    
    /**
     * Keeps a buffer of the link we are building...
     */
    private StringBuffer link = new StringBuffer();

    private ParameterPasser params = new ParameterPasser();

    /**
     * Noop contructor for use with Xalan as an Extension. 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public LinkProducer() { }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public LinkProducer( ParameterPasser params,
                         HttpSession session,
                         String sequenceName ) {

        this.link = new StringBuffer();

        this.link.append( session.getAttribute( ReptileResources.REPTILE_HOME_LOCATION_KEY ) );

        this.params = new ParameterPasser();
        
        this.value( "reptile.sequence.name", sequenceName );
        
    }
    
    /**
     * Create a new  link.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void newLink( XSLProcessorContext context,
                         ElemExtensionCall elem ) {

        this.link = new StringBuffer();

        this.params = new ParameterPasser();
        
        this.link.append( getParameter( context, ReptileResources.REPTILE_HOME_LOCATION_KEY ) );

    }

    /**
     * @see #newLink
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void newLink( ParameterPasser params ) {
        
        this.link = new StringBuffer();

        this.params = new ParameterPasser();
        
        this.link.append( params.getString( ReptileResources.REPTILE_HOME_LOCATION_KEY ) );

    }
    
    /**
     * Add the given param to the link.  Two attributes can be given.  "name" is
     * a required parameter name and "value" is an optional value which can
     * override the XSLT parameter's value.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void param( XSLProcessorContext context,
                       ElemExtensionCall elem ) {

        //FIXME: we need to pull out XPath values... Example {@name}
        
        String name = elem.getAttribute( "name" );

        String value = getParameter( context, name );

        add( name, value );

    }

    /**
     * Get a param from the HTTP Servlet layer.
     * 
     * @see param#
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void param( String name, ServletRequest request ) {

        String value = request.getParameter( name );

        add( name, value );
        
    }

    /**
     * Similar to the param function but is given a value instead.
     * 
     * @see #param
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void value( XSLProcessorContext context,
                       ElemExtensionCall elem ) {

        String name = elem.getAttribute( "name" );
        
        String value = null;

        try { 
            
            value = elem.getAttribute( "value", context.getContextNode(), context.getTransformer() );

            add( name, value );

        } catch ( TransformerException t ) {

            Log.error( t );

        }
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void value( String name, String value ) {

        add( name, value );
        
    }

    /**
     * Add the given name and value as a param to this lik but only if they are
     * valid.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    private void add( String name, String value ) {

        //now... if value still equals null or "" don't show it.

        if ( value != null && value.equals( "" ) == false ) {
        
            this.params.put( name, encode( value ) );

        } 

    }
    
    /**
     * Get the value of this computed link.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public String getLink() {

        //FIXME: if this is called twice we build incorrect URLs!!!.
        
        //compute the URL.  This makes sure that we have the correct match up between ? and & 

        //go through the params and build the URL.

        int size = params.size();
        int i = 0;

        Enumeration keys = params.keys();

        String name;
        String value;
        
        while ( keys.hasMoreElements() ) {

            if ( i == 0 ) 
                this.link.append( "?" );

            name = (String)keys.nextElement();

            value = (String)params.get( name );

            //see if we need to append a &

            this.link.append( name );

            this.link.append( "=" );
            
            this.link.append( value );
            
            if ( i < size - 1) 
                this.link.append( "&" );
            
            ++i;
            
        } 
        
        return this.link.toString();

    }

    /**
     * Same as getLink()
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String toString() {

        return getLink();

    }
    
    /**
     * Get the value of the paramater `name'.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    private String getParameter( XSLProcessorContext context, String name ) {

        String value = (String)context.getTransformer().getParameter( name );

        if ( value == null )
            value = "";
        
        return value;
        
    }

    /**
     * Include all params in the hashtable into this link.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void include( ParameterPasser params ) {

        String name;
        String value;

        Enumeration keys = params.keys();

        while ( keys.hasMoreElements() ) {

            name = (String)keys.nextElement();
            value = (String)params.getString( name );

            if ( name.equals( ReptileResources.REPTILE_ACTION_KEY ) == false && 
                 name.equals( ReptileResources.REPTILE_ACTION_NEXT_SEQUENCE_KEY ) == false && 
                 name.equals( ReptileResources.REPTILE_ACTION_NEXT_LAYER_KEY ) == false &&
                 name.equals( ReptileResources.REPTILE_HOME_LOCATION_KEY ) == false &&
                 name.equals( ReptileResources.REPTILE_SEQUENCE_NAME_KEY ) == false &&
                 name.equals( ReptileResources.REPTILE_CURRENT_LOCATION_KEY ) == false ) {
            
                Log.debug( "LinkProducer: found param " + name );
                value( name, value );

            }
            
        } 

    }

    /**
     * Include all existing parameters in this new URL.  This can be use if you
     * want to add additional params to an existing URL or replace certain ones.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    public void include( XSLProcessorContext context,
                         ElemExtensionCall elem ) {

        this.include( this.params );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    private void reset() {

    }
    
    /**
     * Encode the given string so that we can represent it on a URL.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: LinkProducer.java,v 1.13 2002/02/09 22:39:57 burton Exp $
     */
    private String encode( String value ) {

        if ( value.indexOf( "://" ) != -1 ) {

            value = URLEncoder.encode( value );
            
        } else {

            value = StringUtils.replaceAll( value, " ", "%20" );
            value = StringUtils.replaceAll( value, "/", "%2F" );
            
        }            
        
        return value;

    }
    
}
