/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */


package org.openprivacy.reptile.extensions;


import java.io.*;
import java.net.*;
import java.util.*;

/**
 * 
 *  Handles parsing out JMV runtime information, etc and providing them as an
 *  extension.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: JVMSettings.java,v 1.3 2001/08/04 23:44:58 burton Exp $
 */
public class JVMSettings {

    Enumeration keys = null;
    
    public JVMSettings() {

        this.keys = System.getProperties().keys();

    }

    /**
     * Return true if we have more properties to use.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: JVMSettings.java,v 1.3 2001/08/04 23:44:58 burton Exp $
     */
    public boolean hasMoreProperties() {

        return keys.hasMoreElements();
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: JVMSettings.java,v 1.3 2001/08/04 23:44:58 burton Exp $
     */
    public String nextKey() {

        return keys.nextElement().toString();
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: JVMSettings.java,v 1.3 2001/08/04 23:44:58 burton Exp $
     */
    public String getValue( String key ) {

        return System.getProperty( key );
        
    }

    /**
     * @see Runtime#totalMemory
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: JVMSettings.java,v 1.3 2001/08/04 23:44:58 burton Exp $
     */
    public long getTotalMemory() {

        return Runtime.getRuntime().totalMemory();

    }

    /**
     * @see Runtime#freeMemory
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: JVMSettings.java,v 1.3 2001/08/04 23:44:58 burton Exp $
     */
    public long getFreeMemory() {

        return Runtime.getRuntime().freeMemory();

    }
    
}


