/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.xalan.extensions.*;

import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;


/**
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ImageExtension.java,v 1.3 2002/07/03 22:23:36 burton Exp $
 */
public class ImageExtension {

    /**
     *
     * @see #link
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ImageExtension.java,v 1.3 2002/07/03 22:23:36 burton Exp $
     */
    public String link( String src ) {

        try {
            
            Proxy proxy = ReptileResources.getInstance().getProxy();
        
            //only return this if we found it in the cache.
            if ( proxy.contains( src ) ) {

                return PantherLink.getLink( proxy.get( src ).getFile().getAbsolutePath() );
                
            } else {

                //need to update this location...
                proxy.asyncUpdate( src );
                
                return src;
                
            }

        } catch ( Throwable t ) {

            return null; //should really never happen.

        }

    }

    /**
     * Link to an external image.  If it is in the cache, use a local version.
     *
     * Example:
     * 
     * <image:link src="http://url/to/image.png"/>
     * 
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ImageExtension.java,v 1.3 2002/07/03 22:23:36 burton Exp $
     */
    public String link( XSLProcessorContext context,
                        ElemExtensionCall elem ) {
    
        String src = "";

        try {

            src = elem.getAttribute( "src",
                                     context.getContextNode(),
                                     context.getTransformer() );

            return link( src );
            
        } catch ( Throwable t) {

            Log.error( t );

            return null; //should never happen
            
        }
        
    }
        
}
