/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */


package org.openprivacy.reptile.extensions;


import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.xalan.extensions.*;

import talon.util.*;

/**
 * Holds misc functions for use as extensions within Reptile.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Functions.java,v 1.3 2001/07/31 23:53:16 burton Exp $
 */
public class Functions {


    /**
     * Decode the string for use as a URL
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Functions.java,v 1.3 2001/07/31 23:53:16 burton Exp $
     */
    public String decode( String data ) {

        try {

            return URLDecoder.decode( data );
             
        } catch ( Throwable t ) {

            Log.error( t );

            return t.getMessage();

        } 
            
    }

    
    /**
     * Encode the string for use as a URL
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Functions.java,v 1.3 2001/07/31 23:53:16 burton Exp $
     */
    public String encode( String data ) {

        return URLEncoder.encode( data );
            
    }

}
