/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.util.*;
import java.net.URL;

import org.apache.xalan.extensions.*;

import talon.util.net.*;

import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

/**
 * Builds a favorite icon URL for a given site.  The only major thing this class
 * does is make sure we build a correct URL even if the site information is
 * incorrect.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Favicon.java,v 1.8 2002/07/03 20:36:56 burton Exp $
 */
public class Favicon {

    public static final String FAVICON = "favicon.ico";

    public static final String LOCAL_FAVICON = "/reptile/favicon.ico";
    
    /**
     * Tries to figure out what is the best favicon to use.  If there is a
     * resource on the remove site then we can use this (but it needs to be
     * local).  Else we can just use the local one.
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: Favicon.java,v 1.8 2002/07/03 20:36:56 burton Exp $
     */
    public String get( String siteLocation ) {

        try {

            Proxy proxy = ReptileResources.getInstance().getProxy();
            
            String remoteIcon = new URI( siteLocation ).getScheme() +
                                "://" +
                                new URL( siteLocation ).getHost() +
                                "/" + FAVICON;

            //only return this if we found it in the cache.
            if ( proxy.contains( remoteIcon ) ) {

                //make sure it is an image.

                ProxyEntry pe = proxy.get( remoteIcon );

                //if the URL is an image return it.

                //there is also a bug in some webserver where they report
                //favicon.ico with a mimeType of text/plain.  Check for this.
                
                //if ( pe.getMimeType().isImage() || pe.toString().equals( "text/plain" ) ) {

                //make sure this is a valid Favicon

                if ( pe.getFile().length() == 0 ) {

                    return LOCAL_FAVICON;
                    
                } else {

                    PantherLink.getLink( pe.getFile().getAbsolutePath() );

                }
                    
            } else {

                //FIXME: we should ONLY FAIL ONCE!  This will fail every 5 minutes :(
                
                //need to update this location...
                proxy.asyncUpdate( remoteIcon );
                
                return LOCAL_FAVICON;
                
            }

        } catch ( Throwable t ) { }

        //use our own favicon
        return LOCAL_FAVICON;
        
    }
    
}
