/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import org.apache.xalan.extensions.*;

import talon.util.net.*;

import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

import org.jdom.output.*;

import org.apache.regexp.*;

/**
 * Provides misc tools for escaping content.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: EscapeExtension.java,v 1.4 2002/02/05 04:54:03 burton Exp $
 */
public class EscapeExtension {

    private EscapeOutputter outputter = new EscapeOutputter();
    
    /**
     * Escape content so that it can be placed within an attribute.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    public String attributes( String content ) {

        return outputter.escapeAttributeEntities( content );
        
    }

    /**
     * Escapes HTML 'lite' content.
     *
     * A good example would be the escaping of <i>asdf</i> string.
     * 
     * Given an input of (YOU HAVE TO VIEW SOURCE TO SEE THIS EXAMPLE CORRECTLY)
     * 
     * &lt;i&gt;asdf&lt;/i&gt;
     * 
     * this will escape the content to
     * 
     * <i>asdf</i>
     * 
     * This method should ONLY return valid XHTML elements
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    public String html( String content ) {

        /*

        TODO:

        escape <br> <br/> 

        */
        
        try { 
            
            RE aRegexp = new RE( "&lt;a href=\"([^\"]+)\"&gt;([A-Za-z0-9]+)&lt;/a&gt;" );

            //RE aRegexp = new RE( "&lt" );
            
            while ( aRegexp.match( content ) ) {
                
                String match = aRegexp.getParen( 0 );

                String link = aRegexp.getParen( 1 );
                
                String title = aRegexp.getParen( 2 );
                
                String replacement = "<a href=\"" + link + "\">" + title + "</a>";

                content = aRegexp.subst( match, replacement );
                
            } 

            return content;
            
        } catch ( Throwable t ) {

            //should never happen.
            t.printStackTrace();

            return content;

        }
        
    }

    /**
     * Encode the given data so that it can be part of a URL
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String encode( String data ) {

        return URLEncoder.encode( data );
        
    }
    
    public static void main( String[] args ) {

        System.out.println( new EscapeExtension().html( "&lt;a href=\"http://www.apple.com/\"&gt;Apple&lt;/a&gt;") );
        
    }

    /**
     * Class which allows us to access some XMLOutputter internals.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton - burtonator</a>
     */
    class EscapeOutputter extends XMLOutputter {

        public String escapeAttributeEntities( String content ) {
            return super.escapeAttributeEntities( content );
        }
        
    }

}
