/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xml.serializers.*;
import org.openprivacy.reptile.xslt.*;

import org.openprivacy.panther.components.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;
import org.w3c.dom.*;

/**
 * Handles generating Reptile output from subscription content and applying
 * multiple stylesheets.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: ContentTransformer.java,v 1.20 2002/02/27 07:41:49 burton Exp $
 */
public class ContentTransformer {

    public static final String REPTILE_CONTENT_LOCATION_KEY = "reptile.content.location";
    public static final String REPTILE_CONTENT_TYPE_KEY = "reptile.content.type";
    
    //FIXME: this needs to be moved to a dedicated extensions package.
    
    private ParameterPasser params = null;

    /**
     * Construct a new ContentTransformer with a ParameterPasser.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformer.java,v 1.20 2002/02/27 07:41:49 burton Exp $
     */
    public ContentTransformer( ParameterPasser params ) {

        this.params = params;
        
    }

    /**
     * Need at least one zero arg constructor for Xalan classname instantiation
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformer.java,v 1.20 2002/02/27 07:41:49 burton Exp $
     */
    public ContentTransformer() { }
    
    /**
     * Init this PageDispatcher and merge any required params.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformer.java,v 1.20 2002/02/27 07:41:49 burton Exp $
     */
    public void init(  XSLProcessorContext context,
                       ElemExtensionCall elem ) {

        Log.debug( "INIT ContentTransformer" );

        this.params = new ParameterPasser( context.getTransformer() );
        
    }


    /**
     * Transform the given content.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ContentTransformer.java,v 1.20 2002/02/27 07:41:49 burton Exp $
     */
    public String transform( String location,
                             String inputFormat,
                             String outputFormat ) {

        Assert.assert( location, "Location must be specified." );
        Assert.assert( inputFormat, "inputFormat must be specified." );
        Assert.assert( outputFormat, "outputFormat must be specified." );

        //short circuit.  if the input format and output format are identical,
        //we don't need to do anything.

        if ( inputFormat.equals( outputFormat ) ) {

            Log.debug( "inputFormat and outputFormat are identical: " + inputFormat );
            
            try {

                Proxy proxy = ReptileResources.getInstance().getProxy();
                
                ProxyEntry entry = proxy.get( location );

                return InputStreamUtils.toString( entry.getInputStream() );

            } catch ( Throwable t ) {

                Log.error( t );
                
                return new ErrorXMLSerializer( t ).serializeAsString();

            }

        } 

        Log.debug( "Transforming location: " + location + " with inputFormat: " + inputFormat );

        params.put( REPTILE_CONTENT_LOCATION_KEY, location );

        params.put( REPTILE_CONTENT_TYPE_KEY, inputFormat );
        
        //this isn't a normal operation.  if the user want's to output a
        //sequence as content, go ahead.
        if ( inputFormat.equals( ReptileResources.STYLESHEET_SEQUENCE_NAMESPACE ) ) {

            try {

                return SequenceDispatcher.dispatch( location, params );

            } catch ( Exception e ) {

                Log.error( e );
                
                return new ErrorXMLSerializer( e ).serializeAsString();
                
            }
            
        } 

        try {

            ContentTransformerHandler handler = new ContentTransformerHandler( inputFormat, outputFormat );
            
            StylesheetStack ss = handler.getStylesheetStack();

            //get the correct stylesheet via the map...

            SequenceDispatchEntry sde = new SequenceDispatchEntry( "urn:content-transformer" );

            //some maps can support their own skeletons.
            String skeleton = handler.getSkeleton();
            
            if ( skeleton != null ) {

                sde.setSkeleton( skeleton );

            } else {
                
                sde.setSkeleton( location );
                 
            }

            sde.setLocation( location );
            
            sde.setStylesheetStack( ss );                

            //always case ContentTransformer content.  
            sde.setCacheable( true );

            String result = StylesheetEngineFactory.getStylesheetEngine().transform( sde, params );
            
            return result;

        } catch ( Throwable t ) {

            //FIXME: http://bugzilla.openprivacy.org/show_bug.cgi?id=66
            
            Log.error( t );
            
            Log.debug( "Dumping serialized version of exception " );
            
            return new ErrorXMLSerializer( t ).serializeAsString();
            
        }

    }

    /**
     * Return true if this given contentType is an RSS channel.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public boolean isSupported( String contentType ) {

        //FIXME: we are hard coding this right now.  Very bad!

        return contentType.equals( "http://my.netscape.com/publish/formats/rss-0.91.dtd" ) ||
               contentType.equals( "http://my.netscape.com/rdf/simple/0.9/" ) ||
               contentType.equals( "http://my.netscape.com/publish/formats/rss-0.9.dtd" ) ||
               contentType.equals( "http://www.scripting.com/dtd/rss-0.92.dtd") ||
               contentType.equals( "http://purl.org/rss/1.0/" );

    }
        
}
