/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have obtaind with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.extensions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.resources.*;
import talon.util.net.*;

import org.openprivacy.reptile.om.*;

import org.apache.xalan.extensions.*;
import org.apache.xalan.templates.*;

import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.search.impl.*;
import org.openprivacy.reptile.search.requests.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xml.serializers.*;

import talon.util.*;

import javax.xml.transform.TransformerException;

import org.jdom.*;
import org.jdom.output.*;

import org.openprivacy.panther.components.*;

/**
 * Responsible for rendering an RSS channel from the network or the DB, which
 * ever is more appropriate.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ChannelRenderExtension.java,v 1.5 2002/04/10 08:34:12 burton Exp $
 */
public class ChannelRenderExtension {

    private XSLProcessorContext context = null;
    
    private ElemExtensionCall elem = null;
    
    /**
     * We have to return a string here.  We are not sure how we are going to
     * pull this out.  A String is a lowest common denominator.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String render( String location, String contentType ) {

        if ( location == null || contentType == null ) {

            return new ErrorXMLSerializer( "location or contentType not specified." ).serializeAsString();
            
        } 
        
        try { 
            
            Channel channel = ChannelPeer.getChannelByLocation( location );

            //FIXME: this is a problem with isSubscription...
            
            if ( channel != null && channel.isSubscription() ) {
                
                return getAsSubscription( channel );
                
            } else {
                
                return getAsChannel( location, contentType );
                
            }
            
        } catch ( Throwable t ) {

            Log.error( "Failed render for location: " + location );
            
            t.printStackTrace();
            
            return new ErrorXMLSerializer( t ).serializeAsString();
            
        }
        
    }

    /**
     * Get this from the DB as a search request.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getAsSubscription( Channel channel ) throws Exception {

        SearchProvider sp = SearchProviderManager.getInstance()
            .newProvider( ArticleSearchProvider.class );

        String location = channel.getLocation();

        SearchRequest request = new RSSChannelSearchRequest( location );
        
        //search this weblog..
        sp.search( request );

        int count = sp.getResultCount();

        if ( count == 0 ) {

            Log.warn( "Found zero articles for " + location );
            
        } 
    
        SearchRecord record = new SearchRecord();

        Element rdf = new Element( "RDF", ReptileNamespaces.JDOM_RDF );

        //add the channel ...
        this.addChannel( rdf, channel );

        int max = request.getMaxCount();
        
        for ( int i = 0; i < count && i < max; ++ i ) {

            record.setIndex( i );

            //visit this provider so that we have the info.
            sp.record( record );

            Element item = new Element( "item", ReptileNamespaces.JDOM_RSS );
            
            item.addContent( new Element( "title", ReptileNamespaces.JDOM_RSS ).setText( record.getTitle() ) );
            item.addContent( new Element( "link", ReptileNamespaces.JDOM_RSS ).setText( record.getLink() ) );
            item.addContent( new Element( "description", ReptileNamespaces.JDOM_RSS ).setText( record.getDescription() ) );

            rdf.addContent( item );
            
        }

        return output( rdf );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private void addChannel( Element rdf, Channel channel ) throws Exception {

        Element rss_channel = new Element( "channel", ReptileNamespaces.JDOM_RSS );
        rdf.addContent( rss_channel );

        //add channel info

        rss_channel.addContent( new Element( "title", ReptileNamespaces.JDOM_RSS ).setText( channel.getTitle() ) );
        rss_channel.addContent( new Element( "link", ReptileNamespaces.JDOM_RSS ).setText( channel.getSite() ) );
        rss_channel.addContent( new Element( "description", ReptileNamespaces.JDOM_RSS ).setText( channel.getDescription() ) );

        Image image = ImagePeer.getImageByChannel( channel.getLocation() );

        if ( image != null ) {
            
            Element rss_image = new Element( "image", ReptileNamespaces.JDOM_RSS );
        
            rss_image.setAttribute( "about", image.getLocation(), ReptileNamespaces.JDOM_RDF );

            rss_image.addContent( new Element( "title", ReptileNamespaces.JDOM_RSS ).setText( image.getTitle() ) );
            rss_image.addContent( new Element( "link", ReptileNamespaces.JDOM_RSS ).setText( channel.getSite() ) );
            rss_image.addContent( new Element( "url", ReptileNamespaces.JDOM_RSS ).setText( image.getLocation() ) );

            rss_channel.addContent( rss_image );
            
        } 

    }
    
    /**
     * Get this from the network.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    public String getAsChannel( String location, String contentType ) throws Exception {

        //get the given location from the proxy (and wait) and use the local
        //file:// URL as the source.
        
        Proxy proxy = ReptileResources.getInstance().getProxy();

        ProxyEntry entry = proxy.getAndWait( location );

        location = entry.getFileLocation();

        ContentTransformer transformer = new ContentTransformer();

        transformer.init( context, elem );

        return transformer.transform( location, contentType, ReptileResources.RSS_1_0_NAMESPACE );
        
    }

    /**
     * Output this element as a string.
     *
     * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
     */
    private String output( Element element ) {

        XMLOutputter outputter = new XMLOutputter();

        outputter.setEncoding( ReptileResources.DEFAULT_XML_ENCODING );
        
        return outputter.outputString( element );

    }

    /**
     * When called from an extension, we call init so that we can get copies of
     * the given params.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: ChannelRenderExtension.java,v 1.5 2002/04/10 08:34:12 burton Exp $
     */
    public void init(  XSLProcessorContext context,
                       ElemExtensionCall elem ) {

        this.context = context;

        this.elem = elem;

    }
    
}
