/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */


package org.openprivacy.reptile.data.htparser;

import org.openprivacy.reptile.data.*;
import org.openprivacy.reptile.util.*;

import org.openprivacy.htparser.factories.*;
import org.openprivacy.htparser.components.*;

import java.util.*;

/**
 * <p>
 * Keep around the results from the HTParser.
 * 
 * <p>
 * While the HTParser does provide a decent parsing mechanism it has no native
 * way to incorporate itself into Reptile int a way we can use.  The
 * HTParserStore provide persistence and keeps track of URLs we have fetched (so
 * that we don't fetch them more than once).
 * 
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
 */
public class HTParserStore implements Persistable {

    private static HTParserStore instance = null;

    //BEGIN instance vars... 
    
    private Hashtable descriptions = new Hashtable();

    /**
     * Stores all attempted description fetches.  IE only fetch once.
     */
    private Hashtable attempted = new Hashtable();
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public void commit() {


    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public void init() throws ReptileException { }
    
    
    /**
     * Get an Instance of the HTParser
     * 
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public static HTParserStore getInstance() {

        if ( instance == null ) { 

            instance = new HTParserStore();

        }

        return instance;

    }

    /**
     * Add a new description...
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public void addDescription( String location,
                                String description ) {

        this.descriptions.put( location, description );
        
    }

    /**
     * Get a new description or "" if it doesn't exist.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public String getDescription( String location ) {

        //fetch a new description if necessary.

        return "";
        
    }

    /**
     * Return true if this URL has been fetched.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public boolean hasAttempted( String location ) {

        return attempted.containsKey( location );
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: HTParserStore.java,v 1.2 2001/07/23 22:03:59 burton Exp $
     */
    public void setAttempted( String location ) {

        this.attempted.put( location, new Long( System.currentTimeMillis() ) );

    }
    
}
