/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.content;

import java.io.*;
import java.net.*;
import java.util.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.event.*;
import org.openprivacy.reptile.extensions.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;
import org.openprivacy.reptile.xslt.*;

/**
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: ContentMetaUpdate.java,v 1.3 2001/12/22 08:25:11 burton Exp $
 */
public class ContentMetaUpdate {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public static void update( String location, String contentType ) {

        ContentTransformer t = new ContentTransformer();
        
        if ( t.isSupported( contentType ) ) {

            ParameterPasser params = new ParameterPasser();

            params.put( "location", location );
            params.put( "inputFormat", contentType );
            params.put( "outputFormat", ReptileResources.RSS_1_0_NAMESPACE );

            try {

                new SequenceDispatcher().dispatch( "urn:content-meta-update", params );
                
            } catch ( Throwable th ) {

                Log.error( th );

            }

        } else {
            Log.error( "Asked to update invalid contentType: " + contentType );
        }

    }
    
}
