/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.cache.sequence;

import java.io.*;
import java.net.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import talon.components.*;
import talon.util.net.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.util.*;

import talon.util.*;

/**
 * A handle for items within the sequence cache.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
 */
public class SequenceCacheHandle {
    
    private ParameterPasser params;
    
    private SequenceDispatchEntry sde;

    /**
     * 
     * Create a new <code>SequenceCacheHandle</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public SequenceCacheHandle( SequenceDispatchEntry sde,
                                ParameterPasser params ) {
        
        this.params = params;
        
        this.sde = sde;

        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public SequenceDispatchEntry getSequenceDispatchEntry() {

        return this.sde;
        
    }

    /**
     * Get the parameter passer.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public ParameterPasser getParameterPasser() {

        return this.params;
        
    }

    /**
     * Return true if this is cacheable...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public boolean cacheable() {

        return sde.cacheable();

    }
    
    /**
     * Return this as a string...
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public String toString() {

        return "cache:/sequence/" + sde.getName();
        
    }

    /**
     * Return true if the given object equals this object.
     *
     * @see Object#equals
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public boolean equals( Object obj ) {

        if ( this.getClass() == obj.getClass() ) {

            SequenceCacheHandle other = (SequenceCacheHandle)obj;

            return getSequenceDispatchEntry().equals( other.getSequenceDispatchEntry() );
            
        } 

        return true;
        
    }                                         
    
    /**
     * @see Object#hashCode
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceCacheHandle.java,v 1.6 2001/12/12 09:29:05 burton Exp $
     */
    public int hashCode() {

        //WARNING: note that we do NOT check on passed parameters right now.  

        int hashCode = getSequenceDispatchEntry().hashCode();

        return hashCode;
        
    }
    
}

