/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.cache.sequence;

import java.io.*;
import java.util.*;

import javax.xml.transform.*;
import javax.xml.transform.stream.*;

import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import org.openprivacy.panther.components.*;
import org.openprivacy.panther.util.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xslt.*;

/**
 * A handle for items within the sequence cache.
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SequenceCacheEntry.java,v 1.7 2002/02/21 22:41:23 burton Exp $
 */
public class SequenceCacheEntry {
    
    private String content = null;

    private SequenceCacheHandle handle = null;

    /**
     * Keep a group of proxy entries so that we can watch to see if they have
     * changed.
     */
    private ProxyEntryGroup group = new ProxyEntryGroup();

    /**
     * 
     * Create a new <code>SequenceCacheEntry</code> instance.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceCacheEntry.java,v 1.7 2002/02/21 22:41:23 burton Exp $
     */
    public SequenceCacheEntry( SequenceCacheHandle handle,
                               String content ) throws Exception {

        this.handle = handle;
        this.content = content;

        dependencies();
        
    }
    
    /**
     * Calculate all dependencies.
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     * @version $Id: SequenceCacheEntry.java,v 1.7 2002/02/21 22:41:23 burton Exp $
     */
    private void dependencies() throws Exception {

        Proxy proxy = ReptileResources.getInstance().getProxy();

        SequenceDispatchEntry sde = handle.getSequenceDispatchEntry();
        
        //add the skeleton it relies on
        group.add( proxy.get( sde.getSkeleton() ) );

        //add the stylesheets...

        StylesheetStack ss = sde.getStylesheetStack();

        Iterator i = ss.getIterator();

        while ( i.hasNext() ) {

            URI u = (URI)i.next();

            group.add( proxy.get( u ) );
            
        } 
        
    }
    
    /**
     * 
     * Get the content of this cached sequence.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceCacheEntry.java,v 1.7 2002/02/21 22:41:23 burton Exp $
     */
    public String getContent() {
        
        return this.content;
        
    }

    /**
     * Return true if any of the resources for this document have changed.
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: SequenceCacheEntry.java,v 1.7 2002/02/21 22:41:23 burton Exp $
     */
    public boolean stale() {

        return group.hasChanged();
        
    }

    
}
