/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions.util;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.xslt.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

/**
 * Given a resource, will apply a sequence and then save the output back to this
 * resource..
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: UpdateResource.java,v 1.7 2001/12/24 08:18:38 burton Exp $
 */
public class UpdateResource {

    public static void update( String resource,
                               String sequence,
                               ParameterPasser params )  throws ReptileException {

        try { 

            params.put( ReptileResources.REPTILE_SEQUENCE_NAME_KEY, sequence );
            
            //dispatch this sequence and get it's output
            
            String output = SequenceDispatcher.dispatch( params );
            
            //
            Proxy proxy = ReptileResources.getInstance().getProxy();
            
            OutputStream os = proxy.getResource( resource ).getOutputStream();

            Log.message( "Updating resource: " + resource );
            
            os.write( output.getBytes() );
            os.flush();
            os.close();
            
        } catch ( Throwable t ) {

            Log.error( t );
            
            throw new ReptileException( t );
            
        }
        
    }
    
}

