/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

import org.openprivacy.reptile.actions.util.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.om.*;

/**
 * Handles updating subscription markup when the user makes changes to Reptile.
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: UpdateSubscriptions.java,v 1.13 2002/02/26 00:07:30 burton Exp $
 */
public class UpdateSubscriptions implements Action {

    public ActionDirective perform( ParameterPasser params, 
                         HttpSession session ) throws Exception {
        
        Log.message( "Updating subscriptions... " );

        //update the category with the new-category if this was provided.
        
        String newCategory = params.getString( "reptile.channel-management.edit.new-category" );
        String scategory = params.getString( "reptile.channel-management.edit.category" );

        Category cat = null;
        
        if ( newCategory != null && newCategory.equals( "" ) == false ) {

            //create a new category in the DB.

            //see if the category is in the DB already

            cat = CategoryPeer.getCategoryByName( newCategory );

            if ( cat == null ) {

                //it is is not null... we don't need to do anything.
            
                cat = new Category();
                cat.setName( newCategory );
                
                cat.save();

                cat = CategoryPeer.getCategoryByName( newCategory );
                
            } 
            
        } else {

            cat = CategoryPeer.getCategoryByName( scategory );
            
        }

        //make sure we have a category here.

        if ( cat == null ) {
            throw new Exception( "Could not find category." );
        } 
        
        String location = params.getString( "reptile.channel-management.location" );
        String contentType = params.getString( "reptile.channel-management.contentType" );

        Channel channel = ChannelPeer.getChannelByLocation( location );

        //ok... if this is  null it means that this is a manual subscriptions.

        if ( channel == null ) {

            Log.message( "Channel not in db: " + location );
            
            channel = new Channel();
            
        } 

        //perform changes to this channel.

        if ( channel.getContentType() == null ) 
            channel.setContentType( contentType ) ;

        if ( channel.getLocation() == null ) 
            channel.setLocation( location ) ;

        channel.setSubscribed( ChannelPeer.CHANNEL_SUBSCRIBED );

        if ( channel.getTitle() == null )
            //set the title if not specified.
            channel.setTitle( "UNDEFINED" );

        channel.setCategory( cat );

        channel.setCategoryFk( cat.getId() );

        channel.save();

        //return to the correct URL..
        params.put( ReptileResources.REPTILE_ACTION_NEXT_SEQUENCE_KEY, "urn:subscriptions" );
        
        params.put( ReptileResources.REPTILE_ACTION_NEXT_LAYER_KEY, cat.getName() );
        
        return null;

    }
    
}

