/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.cache.sequence.*;
import org.openprivacy.reptile.extensions.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.xml.*;

import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * 
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: UpdateReadMarks.java,v 1.16 2002/02/27 08:50:52 burton Exp $
 */
public class UpdateReadMarks implements Action {

    public static final String OPERATION_KEY = "reptile.feature.read-marks.operation";

    public static final String CONTENT_TYPE_KEY = "reptile.feature.read-marks.contentType";

    public static final String LOCATION_KEY = "reptile.feature.read-marks.location";

    public static final String OPERATION_READ = "read";

    public static final String OPERATION_UNREAD = "unread";
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: UpdateReadMarks.java,v 1.16 2002/02/27 08:50:52 burton Exp $
     */
    public ActionDirective perform( ParameterPasser params,
                                    HttpSession session ) throws Exception {

        String operation = params.getString( OPERATION_KEY );

        String contentType = params.getString( CONTENT_TYPE_KEY );

        String location = params.getString( LOCATION_KEY );

        Assert.assert( operation, "operation not found" );
        Assert.assert( contentType, "contentType not found" );
        Assert.assert( location, "location not found" );        
        
        if ( operation.equals( OPERATION_READ ) ) {

            ChannelPeer.markChannelRead( location );
            
        } else if ( operation.equals( OPERATION_UNREAD ) ) {

            ChannelPeer.markChannelUnread( location );
            
        } else {
            throw new Exception( "invalid operation: " + operation );
        }
        
        //flush the cache for this resource...

        //FIXME: this should use the DB.

        SequenceCache.getInstance().flush( location );

        return null;
        
    }
    
}

