/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

import org.openprivacy.panther.components.*;

import org.openprivacy.reptile.actions.util.*;

/**
 * Generic action so that we can apply a stylesheet to a resource and save its
 * output.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: UpdateContent.java,v 1.2 2001/09/23 01:06:56 burton Exp $
 */
public class UpdateContent implements Action {

    public static final String RESOURCE_KEY = "reptile.update_content.resource";
    public static final String SEQUENCE_KEY = "reptile.update_content.sequence";
    
    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public ActionDirective perform( ParameterPasser params,
                                    HttpSession session ) throws Exception {
        
        String resource = params.getString( RESOURCE_KEY );

        String sequence = params.getString( SEQUENCE_KEY );

        if ( resource == null || sequence == null ) {

            throw new Exception( "The params resource or sequence were not specified." );
            
        } 
        
        UpdateResource.update( resource, sequence, params );

        return null;
        
    }
    
}

