/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.om.*;
import org.openprivacy.reptile.tasks.*;

import org.openprivacy.panther.components.*;

import org.openprivacy.reptile.actions.util.*;

import talon.*;
import talon.util.*;

/**
 * Generic action so that we can apply a stylesheet to a resource and save its
 * output.
 * 
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: Unsubscribe.java,v 1.2 2002/02/27 10:33:04 burton Exp $
 */
public class Unsubscribe implements Action {

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">Kevin A. Burton</a>
     */
    public ActionDirective perform( ParameterPasser params,
                                    HttpSession session ) throws Exception {
        

        String location = params.getString( "reptile.channel-management.location" );
        
        Channel channel = ChannelPeer.getChannelByLocation( location );

        if ( channel != null ) {

            channel.setSubscribed( ChannelPeer.CHANNEL_UNSUBSCRIBED );

            channel.save();

            TaskManager.getInstance().unregister( location );
            
        } else {

            Log.warn( "channel not found: " + channel );
            
        }
        
        return null;
        
    }
    
}

