/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.extensions.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: SearchRefresh.java,v 1.1 2002/02/07 10:00:23 burton Exp $
 */
public class SearchRefresh implements Action {

    /**
     * Handles searching within Reptile.
     *
     * @exception Exception if an error occurs
     */
    public ActionDirective perform( ParameterPasser params, 
                                    HttpSession session ) throws Exception {

        String handle = params.getString( Search.PARAM_SEARCH_PROVIDER_HANDLE );

        if ( handle == null ) {

            throw new Exception( "The provider handle must be specified." );
            
        } 


        SearchProvider provider = SearchProviderManager.getInstance().getSearchProvider( handle );

        SearchRequest request = provider.getSearchRequest();

        provider =  SearchProviderManager.getInstance().newProvider( provider.getClass() );
        
        provider.search( request );        
        
        ActionDirective ad = new ActionDirective();

        //determine the URL to redirect to...

        LinkProducer lp = new LinkProducer( params, session, "urn:search-serialize/page" );

        lp.value( Search.PARAM_SEARCH_PROVIDER_HANDLE, provider.getHandle() );

        // need to redirect to a page that can render the search results...

        ad.setRedirect( lp.toString() );

        return ad;
        
    }
    
}
