/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.util.*;
import org.openprivacy.reptile.tasks.*;
import org.openprivacy.reptile.search.*;
import org.openprivacy.reptile.extensions.*;

/**
 * 
 *
 * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
 * @version $Id: Search.java,v 1.6 2002/07/06 05:57:56 burton Exp $
 */
public class Search implements Action {

    /**
     * The criteria string we should use.  Note that in the future this could be
     * multiple values.
     */
    public static final String PARAM_SEARCH_CRITERIA = "reptile.search.criteria";

    /**
     * Specificy the provider that should run this query.
     */
    public static final String PARAM_SEARCH_PROVIDER = "reptile.search.provider";

    /**
     * Specificy the request (probably an AdvancedSearchRequest) that should run
     * this query.
     */
    public static final String PARAM_SEARCH_REQUEST = "reptile.search.request";

    /**
     * Specify the search order for this query.
     */
    public static final String PARAM_SEARCH_ORDER = "reptile.search.order";

    /**
     * Comma separated list of fields to match Example: title, description,
     * location, etc.
     */
    public static final String PARAM_SEARCH_FIELDS = "reptile.search.fields";

    /**
     * Maximum number of items to return 100, 200, 300, etc
     */
    public static final String PARAM_SEARCH_MAXCOUNT = "reptile.search.maxcount";

    /**
     * Integer based id of the page we need to view.
     */
    public static final String PARAM_SEARCH_PAGE = "reptile.search.page";

    /**
     * Handle of the provider to use.
     */
    public static final String PARAM_SEARCH_PROVIDER_HANDLE = "reptile.search.provider.handle";

    /**
     * Handles searching within Reptile.
     *
     * @exception Exception if an error occurs
     */
    public ActionDirective perform( ParameterPasser params, 
                                    HttpSession session ) throws Exception {

        //FIXME: we need to support multivalued items here.  AKA multiple
        //orders.. etc.
        
        //get params for this request.

        String criteria = params.getString( PARAM_SEARCH_CRITERIA );

        String provider = params.getString( PARAM_SEARCH_PROVIDER );

        if ( criteria == null || provider == null ) {

            throw new Exception( "The criteria and provider must be specified." );
            
        } 

        int maxcount = params.getInt( PARAM_SEARCH_MAXCOUNT, 100 );

        String order = params.getString( PARAM_SEARCH_ORDER );

        String fields = params.getString( PARAM_SEARCH_FIELDS );

        SearchRequest request = new SearchRequest();
        request.addCriteria( criteria );
        request.setMaxCount( maxcount );

        //specifiy the search fields to use.  
        if ( fields != null ) {

            String TITLE_DESCRIPTION = "title or description";

            if ( TITLE_DESCRIPTION.equals( fields ) ) {

                request.addSearchField( "title" );
                request.addSearchField( "description" );
                
            } else {

                request.addSearchField( fields );
                
            }

        } 

        //FIXME: order is not considered right now :(
        
        //execute the search here, get its handle, and then redirect to a page
        //that can view the results.

        SearchProvider sp = SearchProviderManager.getInstance().newProvider( provider, true );

        sp.search( request );        
        
        ActionDirective ad = new ActionDirective();

        //determine the URL to redirect to...

        LinkProducer lp = new LinkProducer( params, session, "urn:search-serialize/page" );
        lp.value( PARAM_SEARCH_PROVIDER_HANDLE, sp.getHandle() );

        // need to redirect to a page that can render the search results...

        ad.setRedirect( lp.toString() );

        return ad;
        
    }
    
}
