/*
 *
 * BEGIN HEADER
 *
 * ---- 
 *
 * $ID: PantherProxy.java,v 1.6 2001/06/12 20:58:43 burton Exp $
 * $Project: http://panther.openprivacy.org $
 * $CVSROOT: :pserver:anoncvs@sierra.openprivacy.org:/usr/local/cvs/public $
 * $WebCVS: http://www.openprivacy.org/cgi-bin/cvsweb/cvsweb.cgi/panther/ $
 * $Mailing-List: http://www.openprivacy.org/lists/ $
 * $Bugzilla: http://bugzilla.openprivacy.org/ $
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * ---- 
 *
 * Copyright 2001 OpenPrivacy.org.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the LICENSE which you should have received with this package. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * END HEADER
 * 
 */

package org.openprivacy.reptile.actions;

import java.io.*;
import java.net.*;
import java.util.*;

import talon.*;
import talon.components.*;
import talon.util.*;
import talon.util.net.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.factories.*;

import org.openprivacy.reptile.*;
import org.openprivacy.reptile.util.*;

import org.openprivacy.sierra.factories.*;
import org.openprivacy.sierra.nym.talon.components.*;
import org.openprivacy.sierra.query.talon.components.*;
import org.openprivacy.sierra.query.talon.implementations.*;
import org.openprivacy.sierra.rce.talon.components.*;
import org.openprivacy.sierra.rce.talon.implementations.util.*;
import org.openprivacy.sierra.reputation.*;
import org.openprivacy.sierra.reputation.talon.components.*;
import org.openprivacy.sierra.reputation.talon.implementations.*;
import org.openprivacy.sierra.util.*;

/**
 * 
 *
 * @author <a href="mailto:burton@openprivacy.org">Kevin A. Burton</a>
 * @version $Id: PutReputation.java,v 1.7 2002/02/04 22:47:32 burton Exp $
 */
public class PutReputation implements Action {

    public ActionDirective perform( ParameterPasser params,
                                    HttpSession session ) throws Exception {

        Log.debug( "Performing operation: PutReputation" );
            
            //get the URI
        String identifier = params.getString( "identifier" );
        float option = params.getFloat( "payload-option" );

        putReputation( getNymBuilder( session ), identifier, option );

        return null;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: PutReputation.java,v 1.7 2002/02/04 22:47:32 burton Exp $
     */
    private NymBuilder getNymBuilder( HttpSession session ) throws ServletException {

        NymBuilder nb = (NymBuilder)session.getAttribute( NymBuilder.class.getName() );

        if ( nb == null ) {

            throw new ServletException( "ERROR: could not find NymBuilder in this session." );

        } 
        
        return nb;
        
    }

    /**
     * 
     *
     * @author <a href="mailto:burton@relativity.yi.org">burtonator</a>
     * @version $Id: PutReputation.java,v 1.7 2002/02/04 22:47:32 burton Exp $
     */
    private void putReputation( NymBuilder nb,
                               String uri,
                               float option ) {

        try { 

            RCE rce = RCEFactory.getInstance();
        
            Reputation rep = ReputationFactory.getInstance();

            rep.setReference( ReferenceFactory.getInstance( uri ) );

            OverallMarkupPayload payload = (OverallMarkupPayload)ComponentFactory
                .getInstance( OverallMarkupPayload.class );

            payload.setOption( option );
        
            rep.addPayload( payload );
        
            ReputationConstrainer.constrain( rep, nb );

            Log.debug( "Putting a reputation with a value of: " + option, this );
        
            rce.putReputation( rep );
            
        } catch ( Throwable t ) {

            Log.error( t );

        }
        
    }

}
